/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db.vdx;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.BinaryDataSet;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WinstonDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VDXSource
implements DataSource {
    protected WinstonDatabase winston;
    protected Data data;
    protected Channels channels;

    public void initialize(ConfigFile cf) {
        if (this.winston == null) {
            String driver = cf.getString("driver");
            String prefix = cf.getString("prefix");
            String url = cf.getString("url");
            int cacheCap = Util.stringToInt((String)cf.getString("statementCacheCap"), (int)100);
            this.winston = new WinstonDatabase(driver, url, prefix, cacheCap);
        }
        this.data = new Data(this.winston);
        this.channels = new Channels(this.winston);
    }

    public void defaultDisconnect() {
        this.winston.close();
    }

    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action.equals("channels")) {
            List<Channel> chs = this.channels.getChannels();
            ArrayList<String> result = new ArrayList<String>();
            for (Channel ch : chs) {
                result.add(ch.toVDXString());
            }
            return new TextResult(result);
        }
        if (action.equals("data") || action == null) {
            int cid = Integer.parseInt(params.get("ch"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            double period = Util.stringToDouble((String)params.get("period"), (double)60.0);
            String code = this.channels.getChannelCode(cid);
            BinaryDataSet data = this.getData(code, st, et, period);
            if (data != null) {
                return new BinaryResult(data);
            }
        }
        return null;
    }

    public abstract void disconnect();

    protected abstract BinaryDataSet getData(String var1, double var2, double var4, double var6);
}

