/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Retriable;
import gov.usgs.util.Util;
import gov.usgs.winston.db.PreparedStatementCache;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WinstonDatabase {
    public static final String WINSTON_TABLE_DATE_FORMAT = "yyyy_MM_dd";
    public static final String CURRENT_SCHEMA_VERSION = "1.1.0";
    private static final String DEFAULT_DATABASE_PREFIX = "W";
    private static final String DEFAULT_CONFIG_FILENAME = "Winston.config";
    private Connection winstonConnection;
    private Statement winstonStatement;
    private boolean winstonConnected;
    private String dbDriver;
    private String dbURL;
    private int cacheCap;
    private String databasePrefix = "W";
    private Logger logger = Log.getLogger((String)"gov.usgs.winston");
    private PreparedStatementCache preparedStatements;

    public WinstonDatabase(String driver, String url, String db) {
        this(driver, url, db, 50);
    }

    public WinstonDatabase(String driver, String url, String db, int c) {
        this.dbDriver = driver;
        this.dbURL = url;
        this.cacheCap = c;
        if (db != null) {
            this.databasePrefix = db;
        }
        this.preparedStatements = new PreparedStatementCache(this.cacheCap, true);
        this.connect();
    }

    public int getCacheCap() {
        return this.cacheCap;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger log) {
        this.logger = log;
    }

    public void connect() {
        this.winstonConnected = false;
        try {
            Class.forName(this.dbDriver).newInstance();
            DriverManager.setLoginTimeout(3);
            this.winstonConnection = DriverManager.getConnection(this.dbURL);
            this.winstonStatement = this.winstonConnection.createStatement();
            this.winstonConnected = true;
            this.preparedStatements.clear();
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Could not load the database driver, check your CLASSPATH.", Util.getLineNumber((Object)this, (Throwable)e));
            System.exit(-1);
        }
        catch (Exception e) {
            this.winstonConnection = null;
            this.winstonStatement = null;
            this.logger.log(Level.SEVERE, "Could not connect to Winston.", e);
            this.winstonConnected = false;
        }
    }

    public void close() {
        if (!this.checkConnect()) {
            return;
        }
        try {
            this.winstonStatement.close();
            this.winstonConnection.close();
            this.winstonConnected = false;
        }
        catch (Exception e) {
            this.logger.warning("Error closing database.  This is unusual, but not critical.");
        }
    }

    public boolean checkConnect() {
        return this.checkConnect(true);
    }

    public boolean checkConnect(boolean verbose) {
        if (this.winstonConnected) {
            return true;
        }
        new Retriable<Object>(){

            public boolean attempt() {
                WinstonDatabase.this.connect();
                return WinstonDatabase.this.winstonConnected;
            }
        }.go();
        return this.winstonConnected;
    }

    public boolean connected() {
        return this.winstonConnected;
    }

    public Connection getConnection() {
        return this.winstonConnection;
    }

    public Statement getStatement() {
        return this.winstonStatement;
    }

    public String getSchemaVersion() {
        this.useRootDatabase();
        String sv = null;
        try {
            ResultSet rs = this.winstonStatement.executeQuery("SELECT schemaversion FROM version ORDER BY installtime DESC LIMIT 1");
            rs.next();
            sv = rs.getString(1);
        }
        catch (SQLException e) {
            sv = "1.0.0";
        }
        return sv;
    }

    public boolean execute(final String sql) {
        Boolean b = (Boolean)new Retriable<Boolean>(){

            public void attemptFix() {
                WinstonDatabase.this.close();
                WinstonDatabase.this.connect();
            }

            public boolean attempt() {
                try {
                    WinstonDatabase.this.winstonStatement.execute(sql);
                    this.result = new Boolean(true);
                    return true;
                }
                catch (SQLException e) {
                    WinstonDatabase.this.logger.log(Level.SEVERE, "execute() failed, SQL: " + sql, e);
                    this.result = new Boolean(false);
                    return false;
                }
            }
        }.go();
        return b != null && b != false;
    }

    public ResultSet executeQuery(final String sql) {
        ResultSet rs = (ResultSet)new Retriable<ResultSet>(){

            public void attemptFix() {
                WinstonDatabase.this.close();
                WinstonDatabase.this.connect();
            }

            public boolean attempt() {
                try {
                    this.result = WinstonDatabase.this.winstonStatement.executeQuery(sql);
                    return true;
                }
                catch (SQLException e) {
                    WinstonDatabase.this.logger.log(Level.SEVERE, "executeQuery() failed, SQL: " + sql, e);
                    return false;
                }
            }
        }.go();
        return rs;
    }

    public String getDatabasePrefix() {
        return this.databasePrefix;
    }

    private void createTables() {
        try {
            this.getStatement().execute("CREATE TABLE instruments (iid INT PRIMARY KEY AUTO_INCREMENT,name VARCHAR(255) UNIQUE, description VARCHAR(255), lon DOUBLE DEFAULT -999, lat DOUBLE DEFAULT -999, height DOUBLE DEFAULT -999, timezone VARCHAR(128))");
            this.getStatement().execute("CREATE TABLE channels (sid INT PRIMARY KEY AUTO_INCREMENT, iid INT, code VARCHAR(50), st DOUBLE, et DOUBLE, alias VARCHAR(255), unit VARCHAR(255), linearA DOUBLE DEFAULT 1E300, linearB DOUBLE DEFAULT 1E300)");
            this.getStatement().execute("CREATE TABLE version (schemaversion VARCHAR(10), installtime DATETIME)");
            this.getStatement().execute("INSERT INTO version VALUES ('1.1.0', NOW())");
            this.getStatement().execute("CREATE TABLE grouplinks (glid INT PRIMARY KEY AUTO_INCREMENT, sid INT, nid INT)");
            this.getStatement().execute("CREATE TABLE groupnodes (nid INT PRIMARY KEY AUTO_INCREMENT, parent INT DEFAULT 0, name CHAR(255), open BOOL DEFAULT 0)");
            this.getStatement().execute("CREATE TABLE channelmetadata (cmid INT PRIMARY KEY AUTO_INCREMENT, sid INT, name VARCHAR(255), value TEXT)");
            this.getStatement().execute("CREATE TABLE instrumentmetadata (imid INT PRIMARY KEY AUTO_INCREMENT, iid INT, name VARCHAR(255), value TEXT)");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not create tables in WWS database.  Are permissions set properly?", e);
        }
    }

    public boolean useRootDatabase() {
        return this.useDatabase("ROOT");
    }

    public boolean useDatabase(String db) {
        if (!this.checkConnect()) {
            return false;
        }
        try {
            try {
                this.winstonStatement.execute("USE " + this.databasePrefix + "_" + db);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Lost connection to database, attempting to reconnect.");
                this.close();
                this.connect();
            }
            this.winstonStatement.execute("USE " + this.databasePrefix + "_" + db);
            return true;
        }
        catch (SQLException e) {
            if (e.getMessage().indexOf("Unknown database") != -1) {
                this.logger.log(Level.SEVERE, "Attempt to use nonexistent database: " + db);
            } else {
                this.logger.log(Level.SEVERE, "Could not use database: " + db, e);
            }
            return false;
        }
    }

    public boolean checkDatabase() {
        if (!this.checkConnect()) {
            return false;
        }
        try {
            boolean failed = false;
            try {
                this.getStatement().execute("USE " + this.getDatabasePrefix() + "_ROOT");
            }
            catch (Exception e) {
                failed = true;
            }
            if (failed) {
                this.getStatement().execute("CREATE DATABASE " + this.getDatabasePrefix() + "_ROOT");
                this.getStatement().execute("USE " + this.getDatabasePrefix() + "_ROOT");
                this.logger.info("Created new Winston database: " + this.getDatabasePrefix());
                this.createTables();
            }
            return true;
        }
        catch (Exception e) {
            this.logger.severe("Could not locate or create WWS database.  Are permissions set properly?");
            return false;
        }
    }

    public boolean tableExists(String db, String table) {
        try {
            ResultSet rs = this.getStatement().executeQuery(String.format("SELECT COUNT(*) FROM %s_%s.%s", this.databasePrefix, db, table));
            boolean result = rs.next();
            rs.close();
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            PreparedStatement ps = (PreparedStatement)this.preparedStatements.get(sql);
            if (ps == null) {
                ps = this.winstonConnection.prepareStatement(sql);
                this.preparedStatements.put(sql, ps);
                this.logger.fine("Adding statement to cache: " + sql);
            }
            return ps;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not prepare statement.", e);
            return null;
        }
    }

    public static WinstonDatabase processWinstonConfigFile() {
        return WinstonDatabase.processWinstonConfigFile(new ConfigFile(DEFAULT_CONFIG_FILENAME));
    }

    public static WinstonDatabase processWinstonConfigFile(ConfigFile cf) {
        String driver = cf.getString("winston.driver");
        String url = cf.getString("winston.url");
        String db = cf.getString("winston.prefix");
        int cacheCap = Util.stringToInt((String)cf.getString("winston.statementCacheCap"), (int)100);
        return new WinstonDatabase(driver, url, db, cacheCap);
    }

    public static void main(String[] args) {
    }
}

