/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.Util;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaveServerEmulator {
    private WinstonDatabase winston;
    private Channels channels;
    private Data data;
    private DateFormat dateFormat;
    private DecimalFormat decimalFormat;

    public WaveServerEmulator(WinstonDatabase w) {
        this.winston = w;
        this.channels = new Channels(w);
        this.data = new Data(w);
        this.dateFormat = new SimpleDateFormat("yyyy_MM_dd");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
        this.decimalFormat.setMaximumFractionDigits(200);
        this.decimalFormat.setGroupingUsed(false);
    }

    public int getChannelID(String s, String c, String n, String l) {
        String loc = "";
        if (l != null && !l.equals("--")) {
            loc = "$" + l;
        }
        String trueCode = s + "$" + c + "$" + n + loc;
        int id = this.channels.getChannelID(trueCode);
        return id;
    }

    public int getChannelID(String s, String c, String n) {
        return this.getChannelID(s, c, n, null);
    }

    public List<String> getWaveServerMenu(boolean scnl, double embargo, double span) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        List<Channel> sts = this.channels.getChannels();
        if (sts == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(sts.size());
        for (Channel st : sts) {
            String[] ss = st.getCode().split("\\$");
            double[] ts = new double[]{st.getMinTime(), st.getMaxTime()};
            if (ts == null || ts[0] == 1.0E300 || ts[1] == -1.0E300) continue;
            if (!scnl && ss.length == 3) {
                list.add(" " + st.getSID() + " " + ss[0] + " " + ss[1] + " " + ss[2] + " " + this.decimalFormat.format(Util.j2KToEW((double)ts[0])) + " " + this.decimalFormat.format(Util.j2KToEW((double)ts[1])) + " s4 ");
                continue;
            }
            if (!scnl) continue;
            String loc = ss.length == 4 ? ss[3] : "--";
            String line = " " + st.getSID() + " " + ss[0] + " " + ss[1] + " " + ss[2] + " " + loc + " " + this.decimalFormat.format(Util.j2KToEW((double)ts[0])) + " " + this.decimalFormat.format(Util.j2KToEW((double)ts[1])) + " s4 ";
            list.add(line);
        }
        return list;
    }

    public String getWaveServerMenuItem(int p, double embargo, double span) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            String result = null;
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT code FROM channels WHERE sid=" + p);
            if (rs.next()) {
                String code = rs.getString(1);
                double[] ts = this.data.getTimeSpan(code);
                StringTokenizer st = new StringTokenizer(code, "$");
                String sta = st.nextToken();
                String ch = st.nextToken();
                String nw = st.nextToken();
                result = " " + p + " " + sta + " " + ch + " " + nw + " " + this.decimalFormat.format(Util.j2KToEW((double)ts[0])) + " " + this.decimalFormat.format(Util.j2KToEW((double)ts[1])) + " s4 ";
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get wave server menu item.", Util.getLineNumber((Object)this, (Throwable)e));
            return null;
        }
    }

    public String getWaveServerMenuItem(String s, String c, String n, String l, double embargo, double span) {
        String trueCode;
        int id;
        String loc = "";
        if (l != null && !l.equals("--")) {
            loc = "$" + l;
        }
        if ((id = this.channels.getChannelID(trueCode = s + "$" + c + "$" + n + loc)) == -1) {
            return null;
        }
        return this.getWaveServerMenuItem(id, embargo, span);
    }

    public Object[] getWaveServerRaw(String s, String c, String n, double t1, double t2) {
        return this.getWaveServerRaw(s, c, n, null, t1, t2);
    }

    public Object[] getWaveServerRaw(String s, String c, String n, String l, double t1, double t2) {
        String lc = "";
        if (l != null && !l.equals("--")) {
            lc = "$" + l;
        }
        String code = s + "$" + c + "$" + n + lc;
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        List<byte[]> bufs = this.data.getTraceBufBytes(code, t1, t2);
        if (bufs == null || bufs.size() == 0) {
            return null;
        }
        try {
            int sid = this.channels.getChannelID(code);
            TraceBuf tb0 = new TraceBuf(bufs.get(0));
            TraceBuf tbN = new TraceBuf(bufs.get(bufs.size() - 1));
            int total = 0;
            for (byte[] buf : bufs) {
                total += buf.length;
            }
            String lr = "";
            if (l != null) {
                lr = " " + l;
            }
            String hdr = sid + " " + s + " " + c + " " + n + lr + " F " + tb0.dataType + " " + tb0.getStartTime() + " " + tbN.getEndTime() + " " + total;
            return new Object[]{hdr, new Integer(total), bufs};
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get raw wave.", e);
            return null;
        }
    }
}

