/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.util.ConfigFile;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.SQLException;

public class Upgrade {
    private WinstonDatabase winston;
    private Upgrader[] upgraders = new Upgrader[]{new Upgrader1_0_1to1_1_0(), new Upgrader1_0_0to1_0_1()};

    public Upgrade() {
        ConfigFile cf = new ConfigFile("Winston.config");
        String driver = cf.getString("winston.driver");
        String url = cf.getString("winston.url");
        String db = cf.getString("winston.prefix");
        this.winston = new WinstonDatabase(driver, url, db);
    }

    public Upgrader getUpgrader() {
        String currentSchemaVersion = this.winston.getSchemaVersion();
        for (int i = 0; i < this.upgraders.length; ++i) {
            if (!this.upgraders[i].sourceVersion.equals(currentSchemaVersion)) continue;
            return this.upgraders[i];
        }
        return null;
    }

    public void doUpgrade() {
        Upgrader ugr = this.getUpgrader();
        if (ugr == null) {
            System.out.println("No upgrade necessary.");
        } else {
            System.out.println("Performing upgrade:");
            System.out.println(ugr.description);
            System.out.println();
            System.out.println("Starting upgrade --------------------------------------------------------");
            ugr.upgrade();
            System.out.println("Finished ----------------------------------------------------------------");
        }
    }

    public static void main(String[] args) {
        Upgrade ug = new Upgrade();
        if (args.length == 1 && args[0].equals("--upgrade")) {
            ug.doUpgrade();
        } else {
            String currentSchemaVersion = ug.winston.getSchemaVersion();
            System.out.println("Current Winston schema version: " + currentSchemaVersion);
            System.out.println();
            Upgrader ugr = ug.getUpgrader();
            if (ugr == null) {
                System.out.println("Winston schema up-to-date, no upgrades available.");
            } else {
                System.out.println("Available upgrade:");
                System.out.println(ugr.description);
                System.out.println();
                System.out.println("Run with '--upgrade' option to perform this upgrade.");
            }
        }
    }

    private class Upgrader1_0_0to1_0_1
    extends Upgrader {
        public Upgrader1_0_0to1_0_1() {
            this.sourceVersion = "1.0.0";
            this.destinationVersion = "1.0.1";
            this.description = "\t" + this.getVersionChangeString() + "\n" + "Creates a table in the Winston root database to track schema version.\n" + "Adds longitude and latitude columns to channels table.\n" + "Estimated execution time: under 1 second.";
        }

        public boolean checkSourceVersion() {
            return "1.0.0".equals(Upgrade.this.winston.getSchemaVersion());
        }

        public void upgrade() {
            try {
                System.out.println("Creating version table...");
                Upgrade.this.winston.getStatement().execute("CREATE TABLE version (schemaversion VARCHAR(10), installtime DATETIME)");
                System.out.println("Altering channels table...");
                Upgrade.this.winston.getStatement().execute("ALTER TABLE channels ADD COLUMN lon DOUBLE DEFAULT -999, ADD COLUMN lat DOUBLE DEFAULT -999");
                System.out.println("Inserting old version information...");
                Upgrade.this.winston.getStatement().execute("INSERT INTO version VALUES ('1.0.0', '2000-01-01')");
                System.out.println("Inserting new version information...");
                Upgrade.this.winston.getStatement().execute("INSERT INTO version VALUES ('1.0.1', NOW())");
                this.success();
            }
            catch (SQLException e) {
                System.err.println("There was an exception during upgrade.");
                e.printStackTrace();
            }
        }
    }

    private class Upgrader1_0_1to1_1_0
    extends Upgrader {
        public Upgrader1_0_1to1_1_0() {
            this.sourceVersion = "1.0.1";
            this.destinationVersion = "1.1.0";
            this.description = "\t" + this.getVersionChangeString() + "\n" + "Creates instrument and channel metadata tables and modifies the existing channels table.\n" + "Existing longitude and latitude columns in channels table will no longer be used.\n" + "Estimated execution time: under 1 second.";
        }

        public boolean checkSourceVersion() {
            return "1.0.1".equals(Upgrade.this.winston.getSchemaVersion());
        }

        public void upgrade() {
            try {
                System.out.println("Creating instruments table...");
                Upgrade.this.winston.getStatement().execute("CREATE TABLE instruments (iid INT PRIMARY KEY AUTO_INCREMENT,name VARCHAR(128) UNIQUE, description VARCHAR(255), lon DOUBLE DEFAULT -999, lat DOUBLE DEFAULT -999, height DOUBLE DEFAULT -999, timezone VARCHAR(128))");
                System.out.println("Altering channels table...");
                Upgrade.this.winston.getStatement().execute("ALTER TABLE channels ADD COLUMN iid INT AFTER sid, ADD COLUMN alias VARCHAR(255) AFTER et, ADD COLUMN unit VARCHAR(255) AFTER alias, ADD COLUMN linearA DOUBLE DEFAULT 1E300 AFTER unit, ADD COLUMN linearB DOUBLE DEFAULT 1E300 AFTER linearA");
                System.out.println("Creating groups tables...");
                Upgrade.this.winston.getStatement().execute("CREATE TABLE grouplinks (glid INT PRIMARY KEY AUTO_INCREMENT, sid INT, nid INT)");
                Upgrade.this.winston.getStatement().execute("CREATE TABLE groupnodes (nid INT PRIMARY KEY AUTO_INCREMENT, parent INT DEFAULT 0, name CHAR(255), open BOOL DEFAULT 0)");
                System.out.println("Creating channel metadata table...");
                Upgrade.this.winston.getStatement().execute("CREATE TABLE channelmetadata (cmid INT PRIMARY KEY AUTO_INCREMENT, sid INT, name VARCHAR(255), value TEXT)");
                System.out.println("Creating instrument metadata table...");
                Upgrade.this.winston.getStatement().execute("CREATE TABLE instrumentmetadata (imid INT PRIMARY KEY AUTO_INCREMENT, iid INT, name VARCHAR(255), value TEXT)");
                System.out.println("Inserting new version information...");
                Upgrade.this.winston.getStatement().execute("INSERT INTO version VALUES ('1.1.0', NOW())");
                this.success();
            }
            catch (SQLException e) {
                System.err.println("There was an exception during upgrade.");
                e.printStackTrace();
            }
        }
    }

    private abstract class Upgrader {
        public String sourceVersion;
        public String destinationVersion;
        protected String description;

        private Upgrader() {
        }

        public void success() {
            System.out.println("Upgrade [" + this.getVersionChangeString() + "] successful.");
        }

        public String getVersionChangeString() {
            return this.sourceVersion + " -> " + this.destinationVersion;
        }

        public abstract boolean checkSourceVersion();

        public abstract void upgrade();
    }
}

