/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.winston.db.Admin;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Input {
    private WinstonDatabase winston;
    private DateFormat dateFormat;
    private int maxDays = 0;
    private HashMap<String, ChannelInputOptimizer> channelOptimizers;
    private HashSet<String> checkTableCache;
    private Data data;
    private ArrayList<String> locks = new ArrayList(9);
    private boolean writeLocks = false;
    private ChannelInputOptimizer currentLock;

    public Input(WinstonDatabase w) {
        this.winston = w;
        this.data = new Data(w);
        this.channelOptimizers = new HashMap();
        this.checkTableCache = new HashSet();
        this.dateFormat = new SimpleDateFormat("yyyy_MM_dd");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setWinston(WinstonDatabase db) {
        this.winston = db;
    }

    public void setMaxDays(int i) {
        if (i >= 0) {
            this.maxDays = i;
        }
    }

    public void setTimeSpan(String code, double st, double et) {
        if (!this.winston.checkConnect()) {
            return;
        }
        try {
            ChannelInputOptimizer opt = this.channelOptimizers.get(code);
            if (!Double.isNaN(st)) {
                if (opt != null) {
                    opt.t1 = st;
                }
                this.winston.getStatement().execute("UPDATE " + this.winston.getDatabasePrefix() + "_ROOT.channels SET st=" + st + " WHERE code='" + code + "'");
            }
            if (!Double.isNaN(et)) {
                if (opt != null) {
                    opt.t2 = et;
                }
                this.winston.getStatement().execute("UPDATE " + this.winston.getDatabasePrefix() + "_ROOT.channels SET et=" + et + " WHERE code='" + code + "'");
            }
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not set time span for channel: " + code, e);
        }
    }

    public void purgeTables(String channel, int days) {
        if (days <= 0) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = CurrentTime.getInstance().nowDate();
        Date then = new Date(now.getTime() - (long)days * 86400000L);
        this.winston.getLogger().info("Purging '" + channel + "' tables before: " + df.format(then));
        List<String> list = this.getDayTables(channel);
        boolean deleted = false;
        boolean setTime = false;
        for (String table : list) {
            String[] ss = table.split("\\$\\$");
            if (df.format(then).compareTo(ss[1]) > 0) {
                try {
                    if (!this.winston.useDatabase(channel)) {
                        return;
                    }
                    this.checkTableCache.remove(table);
                    this.winston.getStatement().execute("DROP TABLE " + table);
                    this.winston.getStatement().execute("DROP TABLE " + ss[0] + "$$H" + ss[1]);
                    deleted = true;
                    this.winston.getLogger().info("Deleted table: " + table);
                }
                catch (Exception e) {
                    this.winston.getLogger().severe("Could not drop old table: " + channel + ".  Are permissions set properly?");
                }
                continue;
            }
            if (!deleted) break;
            try {
                String nextLowestTable = table;
                ResultSet rs = this.winston.getStatement().executeQuery("SELECT MIN(st) FROM " + nextLowestTable);
                rs.next();
                double t1 = rs.getDouble(1);
                this.setTimeSpan(channel, t1, Double.NaN);
                rs.close();
                setTime = true;
            }
            catch (Exception e) {
                this.winston.getLogger().severe("Could not update span after dropping table: " + channel);
            }
            break;
        }
        if (deleted && !setTime) {
            this.winston.getLogger().info("Permanently deleting channel: " + channel);
            new Admin(this.winston).deleteChannel(channel);
        }
    }

    private boolean createDayTable(String code, String date) {
        try {
            this.winston.getStatement().execute("CREATE TABLE " + code + "$$" + date + " (" + "st DOUBLE PRIMARY KEY, " + "et DOUBLE, " + "sr DOUBLE, " + "datatype CHAR(3), " + "tracebuf BLOB)");
            this.winston.getStatement().execute("CREATE TABLE " + code + "$$H" + date + " (" + "j2ksec DOUBLE PRIMARY KEY, " + "smin INT, " + "smax INT, " + "rcnt INT, " + "rsam DOUBLE)");
            this.purgeTables(code, this.maxDays);
            return true;
        }
        catch (Exception ex) {
            this.winston.getLogger().severe("Could not create day table: " + code + "$" + date + ".  Are permissions set properly?");
            return false;
        }
    }

    private boolean checkTable(String code, String date) {
        String table = code + "$$" + date;
        if (this.checkTableCache.contains(table)) {
            return true;
        }
        try {
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT COUNT(*) FROM " + table);
            boolean result = rs.next();
            if (result) {
                this.checkTableCache.add(table);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.checkTableCache.clear();
            return this.createDayTable(code, date);
        }
    }

    private boolean tableExists(String code, String date) {
        String table = code + "$$" + date;
        if (this.checkTableCache.contains(table)) {
            return true;
        }
        try {
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT COUNT(*) FROM " + table);
            boolean result = rs.next();
            if (result) {
                this.checkTableCache.add(table);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean createTable(String code, String date) {
        try {
            this.winston.getStatement().execute("CREATE TABLE " + code + "$$" + date + " (" + "st DOUBLE PRIMARY KEY, " + "et DOUBLE, " + "sr DOUBLE, " + "datatype CHAR(3), " + "tracebuf BLOB)");
            this.winston.getStatement().execute("CREATE TABLE " + code + "$$H" + date + " (" + "j2ksec DOUBLE PRIMARY KEY, " + "smin INT, " + "smax INT, " + "rcnt INT, " + "rsam DOUBLE)");
            return true;
        }
        catch (Exception ex) {
            this.winston.getLogger().severe("Could not create day table: " + code + "$" + date + ".  Are permissions set properly?");
            return false;
        }
    }

    public List<String> getDayTables(String code) {
        try {
            ArrayList<String> list = new ArrayList<String>(10);
            if (!this.winston.useDatabase(code)) {
                return null;
            }
            ResultSet rs = this.winston.getStatement().executeQuery("SHOW TABLES");
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            rs.close();
            Collections.sort(list);
            ArrayList<String> dayList = new ArrayList<String>(list.size() / 2);
            for (int i = 0; i < list.size(); ++i) {
                String table = (String)list.get(i);
                String day = table.substring(table.indexOf("$$") + 2);
                if (day.length() != 10 || day.charAt(4) != '_' || day.charAt(7) != '_' || !Character.isDigit(day.charAt(0)) || !Character.isDigit(day.charAt(9))) continue;
                dayList.add(table);
            }
            return dayList;
        }
        catch (Exception e) {
            this.winston.getLogger().severe("Could not generate list of tables: " + code);
            return null;
        }
    }

    public void calculateSpan(String code) {
        try {
            List<String> dayList = this.getDayTables(code);
            double mint = 1.0E300;
            double maxt = -1.0E300;
            String table = dayList.get(0);
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT MIN(st) FROM " + table);
            rs.next();
            mint = Math.min(mint, rs.getDouble(1));
            table = dayList.get(dayList.size() - 1);
            rs = this.winston.getStatement().executeQuery("SELECT MAX(et) FROM " + table);
            rs.next();
            maxt = Math.max(maxt, rs.getDouble(1));
            this.setTimeSpan(code, mint, maxt);
            rs.close();
        }
        catch (Exception e) {
            this.winston.getLogger().severe("Could not calculate span: " + code);
        }
    }

    public void setWriteLock(boolean b) {
        this.writeLocks = b;
    }

    public void unlockTables() {
        if (this.currentLock == null) {
            return;
        }
        try {
            this.winston.getStatement().execute("UNLOCK TABLES");
            this.setTimeSpan(this.currentLock.code, this.currentLock.t1, this.currentLock.t2);
            this.currentLock = null;
            this.writeLocks = false;
            this.locks.clear();
        }
        catch (SQLException e) {
            this.winston.getLogger().log(Level.SEVERE, "Exception while unlocking tables.", e);
        }
    }

    public InputResult inputTraceBuf(TraceBuf tb) {
        InputResult result = InputResult.ERROR;
        try {
            int i;
            String code = tb.toWinstonString();
            ChannelInputOptimizer opt = this.channelOptimizers.get(code);
            if (opt == null) {
                opt = new ChannelInputOptimizer(code);
                this.channelOptimizers.put(code, opt);
                double[] span = this.data.getTimeSpan(code);
                opt.t1 = span[0];
                opt.t2 = span[1];
            }
            this.winston.useDatabase(code);
            double ts = tb.getStartTimeJ2K();
            String date = this.dateFormat.format(Util.j2KToDate((double)ts));
            boolean createdTable = false;
            if (!this.tableExists(code, date)) {
                if (this.createTable(code, date)) {
                    createdTable = true;
                } else {
                    throw new Exception("Could not create table.");
                }
            }
            String table = code + "$$" + date;
            if (this.writeLocks && !this.locks.contains(table)) {
                this.currentLock = opt;
                this.locks.add(table);
                this.locks.add(code + "$$H" + date);
                this.winston.getStatement().execute("LOCK TABLES " + table + " WRITE, " + code + "$$H" + date + " WRITE");
            }
            PreparedStatement insert = this.winston.getPreparedStatement("INSERT IGNORE INTO " + table + " VALUES (?,?,?,?,?)");
            insert.setDouble(1, ts);
            insert.setDouble(2, tb.getEndTimeJ2K());
            insert.setDouble(3, tb.samplingRate);
            insert.setString(4, tb.dataType);
            byte[] stripped = Util.resize((byte[])tb.bytes, (int)(tb.bytes.length - 1));
            byte[] compressed = Util.compress((byte[])stripped);
            insert.setBytes(5, compressed);
            insert.executeUpdate();
            opt.t1 = Math.min(opt.t1, tb.getStartTimeJ2K());
            opt.t2 = Math.max(opt.t2, tb.getEndTimeJ2K());
            if (!this.writeLocks) {
                this.setTimeSpan(code, opt.t1, opt.t2);
            }
            table = code + "$$H" + date;
            double fst = Math.floor(tb.getStartTimeJ2K());
            double cet = Math.ceil(tb.getEndTimeJ2K());
            double[][] heliList = new double[(int)Math.round(cet - fst) + 1][];
            int j = 0;
            for (int i2 = (int)Math.round(fst); i2 <= (int)Math.round(cet); ++i2) {
                boolean filled;
                double[] d = opt.getData(i2);
                if (d == null && !(filled = false)) {
                    d = new double[]{i2, 2.147483647E9, -2.147483648E9, 0.0, 0.0};
                    this.winston.getStatement().execute("INSERT IGNORE INTO " + table + " VALUES (" + i2 + "," + Integer.MAX_VALUE + "," + Integer.MIN_VALUE + ",0,0)");
                }
                heliList[j++] = d;
            }
            double st = tb.getStartTimeJ2K();
            double dt = 1.0 / tb.samplingRate;
            for (i = 0; i < tb.numSamples; ++i) {
                j = (int)(Math.floor(st) - fst);
                double[] d = heliList[j];
                int sample = tb.data[i];
                d[1] = Math.min(d[1], (double)sample);
                d[2] = Math.max(d[2], (double)sample);
                d[4] = (d[4] * d[3] + (double)Math.abs(sample)) / (d[3] + 1.0);
                d[3] = d[3] + 1.0;
                st += dt;
            }
            for (i = 0; i < heliList.length; ++i) {
                int j2k = (int)Math.round(fst + (double)i);
                this.winston.getStatement().execute("UPDATE " + table + " SET smin=" + (int)heliList[i][1] + ", smax=" + (int)heliList[i][2] + ", rcnt=" + (int)heliList[i][3] + ", rsam=" + heliList[i][4] + " WHERE j2ksec=" + j2k);
                opt.putData(j2k, heliList[i]);
            }
            result = createdTable ? InputResult.SUCCESS_CREATED_TABLE : InputResult.SUCCESS;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not insert TraceBuf: " + tb, e);
        }
        return result;
    }

    public boolean inputTraceBuf(TraceBuf tb, boolean fillHeli) {
        try {
            int i;
            String table;
            String date;
            ChannelInputOptimizer opt;
            String code;
            block13: {
                code = tb.toWinstonString();
                opt = this.channelOptimizers.get(code);
                if (opt == null) {
                    opt = new ChannelInputOptimizer(code);
                    this.channelOptimizers.put(code, opt);
                    double[] span = this.data.getTimeSpan(code);
                    opt.t1 = span[0];
                    opt.t2 = span[1];
                }
                this.winston.useDatabase(code);
                double ts = tb.getStartTimeJ2K();
                date = this.dateFormat.format(Util.j2KToDate((double)ts));
                this.checkTable(code, date);
                table = code + "$$" + date;
                if (this.writeLocks && !this.locks.contains(table)) {
                    this.currentLock = opt;
                    this.locks.add(table);
                    this.locks.add(code + "$$H" + date);
                    this.winston.getStatement().execute("LOCK TABLES " + table + " WRITE, " + code + "$$H" + date + " WRITE");
                }
                PreparedStatement insert = this.winston.getPreparedStatement("INSERT INTO " + table + " VALUES (?,?,?,?,?)");
                insert.setDouble(1, ts);
                insert.setDouble(2, tb.getEndTimeJ2K());
                insert.setDouble(3, tb.samplingRate);
                insert.setString(4, tb.dataType);
                byte[] stripped = Util.resize((byte[])tb.bytes, (int)(tb.bytes.length - 1));
                byte[] compressed = Util.compress((byte[])stripped);
                insert.setBytes(5, compressed);
                try {
                    insert.executeUpdate();
                }
                catch (SQLException ex) {
                    if (!ex.getMessage().startsWith("Duplicate entry")) break block13;
                    insert.close();
                    return false;
                }
            }
            opt.t1 = Math.min(opt.t1, tb.getStartTimeJ2K());
            opt.t2 = Math.max(opt.t2, tb.getEndTimeJ2K());
            if (!this.writeLocks) {
                this.setTimeSpan(code, opt.t1, opt.t2);
            }
            table = code + "$$H" + date;
            double fst = Math.floor(tb.getStartTimeJ2K());
            double cet = Math.ceil(tb.getEndTimeJ2K());
            double[][] heliList = new double[(int)Math.round(cet - fst) + 1][];
            int j = 0;
            for (int i2 = (int)Math.round(fst); i2 <= (int)Math.round(cet); ++i2) {
                double[] d = opt.getData(i2);
                if (d == null) {
                    ResultSet rs;
                    boolean filled = false;
                    if (fillHeli && (rs = this.winston.executeQuery("SELECT j2ksec, smin, smax, rcnt, rsam FROM " + table + " WHERE j2ksec=" + i2)).next()) {
                        filled = true;
                        d = new double[]{rs.getDouble(1), rs.getDouble(2), rs.getDouble(3), rs.getDouble(4), rs.getDouble(5)};
                    }
                    if (!filled) {
                        d = new double[]{i2, 2.147483647E9, -2.147483648E9, 0.0, 0.0};
                        this.winston.getStatement().execute("INSERT IGNORE INTO " + table + " VALUES (" + i2 + "," + Integer.MAX_VALUE + "," + Integer.MIN_VALUE + ",0,0)");
                    }
                }
                heliList[j++] = d;
            }
            double st = tb.getStartTimeJ2K();
            double dt = 1.0 / tb.samplingRate;
            for (i = 0; i < tb.numSamples; ++i) {
                j = (int)(Math.floor(st) - fst);
                double[] d = heliList[j];
                int sample = tb.data[i];
                d[1] = Math.min(d[1], (double)sample);
                d[2] = Math.max(d[2], (double)sample);
                d[4] = (d[4] * d[3] + (double)Math.abs(sample)) / (d[3] + 1.0);
                d[3] = d[3] + 1.0;
                st += dt;
            }
            for (i = 0; i < heliList.length; ++i) {
                int j2k = (int)Math.round(fst + (double)i);
                this.winston.getStatement().execute("UPDATE " + table + " SET smin=" + (int)heliList[i][1] + ", smax=" + (int)heliList[i][2] + ", rcnt=" + (int)heliList[i][3] + ", rsam=" + heliList[i][4] + " WHERE j2ksec=" + j2k);
                opt.putData(j2k, heliList[i]);
            }
            return true;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not insert TraceBuf: " + tb, e);
            return false;
        }
    }

    class ChannelInputOptimizer {
        String code;
        double t1;
        double t2;
        TreeMap<Double, double[]> data;

        public ChannelInputOptimizer(String c) {
            this.code = c;
            this.data = new TreeMap();
            this.t1 = Double.NaN;
            this.t2 = Double.NaN;
        }

        public boolean isInitialized() {
            return !Double.isNaN(this.t1);
        }

        public void putData(double j2k, double[] d) {
            this.data.put(j2k, d);
            if (this.data.size() > 60) {
                int numToDelete = this.data.size() - 30;
                Iterator<Double> it = this.data.keySet().iterator();
                for (int i = 0; i < numToDelete; ++i) {
                    it.next();
                    it.remove();
                }
            }
        }

        public double[] getData(double j2k) {
            return this.data.get(j2k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputResult {
        ERROR,
        SUCCESS,
        SUCCESS_CREATED_TABLE;

    }
}

