/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.util.ConfigFile;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Input;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class Admin {
    private WinstonDatabase winston;
    private Channels channels;
    private Input input;

    public Admin(WinstonDatabase w) {
        this.winston = w;
        this.channels = new Channels(this.winston);
        this.input = new Input(this.winston);
    }

    public Admin(String driver, String url, String db) {
        this(new WinstonDatabase(driver, url, db));
    }

    public void calculateTableSpans() {
        try {
            List<Channel> st = this.channels.getChannels();
            Iterator<Channel> it = st.iterator();
            while (it.hasNext()) {
                String code = it.next().getCode();
                System.out.print(code + "...");
                this.input.calculateSpan(code);
                System.out.println("done.");
            }
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Error during calculateTableSpans().", e);
        }
    }

    public void listChannels(boolean times) {
        List<Channel> st = this.channels.getChannels();
        for (Channel ch : st) {
            String code = ch.getCode();
            System.out.print(code);
            if (times) {
                System.out.print("\t" + ch.getMinTime() + "\t" + ch.getMaxTime());
            }
            System.out.println();
        }
    }

    public void deleteChannel(String ch) {
        try {
            this.winston.useRootDatabase();
            this.winston.getStatement().execute("DELETE FROM channels WHERE code='" + ch + "'");
            this.winston.getStatement().execute("DROP DATABASE " + this.winston.getDatabasePrefix() + "_" + ch);
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Error during deleteChannel().", e);
        }
    }

    public void purge(String channel, int days) {
        this.input.purgeTables(channel, days);
    }

    public boolean repairChannel(String day, String ch) {
        try {
            this.winston.useDatabase(ch);
            boolean fix = false;
            Statement st = this.winston.getStatement();
            this.winston.getLogger().info("Checking: " + ch + " " + day);
            ResultSet rs = st.executeQuery("CHECK TABLE " + ch + "$$" + day + " FAST QUICK");
            rs.next();
            String s = rs.getString("Msg_text");
            if (s.endsWith("doesn't exist")) {
                this.winston.getLogger().info(ch + " wave table doesn't exist.");
                return true;
            }
            if (!s.equals("Table is already up to date")) {
                fix = true;
            }
            rs = st.executeQuery("CHECK TABLE " + ch + "$$H" + day + " FAST QUICK");
            rs.next();
            s = rs.getString("Msg_text");
            if (s.endsWith("doesn't exist")) {
                this.winston.getLogger().info(ch + " helicorder table doesn't exist.");
                return true;
            }
            if (!rs.getString("Msg_text").equals("Table is already up to date")) {
                fix = true;
            }
            if (fix) {
                this.winston.getLogger().info("Repairing: " + ch);
                this.winston.getStatement().execute("REPAIR TABLE " + ch + "$$" + day);
                this.winston.getStatement().execute("REPAIR TABLE " + ch + "$$H" + day);
            }
            return true;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Failed to repair: " + ch);
            return false;
        }
    }

    public void repair(String day, String chString) {
        if (chString == null) {
            List<Channel> chs = this.channels.getChannels();
            for (Channel ch : chs) {
                this.repairChannel(day, ch.getCode());
            }
        } else {
            this.repairChannel(day, chString);
        }
    }

    public boolean checkTable(String database, String table) throws SQLException {
        ResultSet rs = this.winston.getStatement().executeQuery("CHECK TABLE " + table + " FAST QUICK");
        rs.next();
        String s = rs.getString("Msg_text");
        if (s.endsWith("doesn't exist")) {
            this.winston.getLogger().info(table + " doesn't exist.");
            return false;
        }
        return s.equals("Table is already up to date");
    }

    public boolean repairTable(String database, String table) {
        try {
            this.winston.useDatabase(database);
            this.winston.getLogger().info("Checking table: " + table);
            boolean ct = this.checkTable(database, table);
            if (ct) {
                return true;
            }
            this.winston.getLogger().info("Repairing table: " + table);
            this.winston.getStatement().execute("REPAIR TABLE " + table + " QUICK");
            ct = this.checkTable(database, table);
            if (ct) {
                return true;
            }
            this.winston.getLogger().info("Still broken, attempting further repair: " + table);
            this.winston.getStatement().execute("REPAIR TABLE " + table + " QUICK USE_FRM");
            return this.checkTable(database, table);
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Failed to repair: " + table);
            return false;
        }
    }

    public void deleteWinston() {
        try {
            List<Channel> chs = this.channels.getChannels();
            for (Channel ch : chs) {
                this.deleteChannel(ch.getCode());
            }
            this.winston.getStatement().execute("DROP DATABASE " + this.winston.getDatabasePrefix() + "_ROOT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Winston Admin\n");
            System.out.println("A collection of commands for administering a Winston database.\n");
            System.out.println("Information about connecting to the Winston database must be present");
            System.out.println("in Winston.config in the current directory.\n");
            System.out.println("Usage:");
            System.out.println("  java gov.usgs.winston.db.Admin [command] [options]\n\n");
            System.out.println("Valid commands:");
            System.out.println("  --list                          lists all channels");
            System.out.println("  --list times                    lists all channels with time span");
            System.out.println("  --delete [channel]              delete the specified channel");
            System.out.println("  --span                          recalculate table spans");
            System.out.println("  --purge [channel] [days]        purge");
            System.out.println("  --repair [YYYY_MM_DD] <channel> repair all tables on given day");
            System.out.println("                                  optionally, just repair one channel");
            System.exit(1);
        }
        ConfigFile cf = new ConfigFile("Winston.config");
        String driver = cf.getString("winston.driver");
        String url = cf.getString("winston.url");
        String db = cf.getString("winston.prefix");
        Admin admin = new Admin(driver, url, db);
        if (args[0].equals("--span")) {
            admin.calculateTableSpans();
        } else if (args[0].equals("--list")) {
            if (args.length >= 2 && args[1].equals("times")) {
                admin.listChannels(true);
            } else {
                admin.listChannels(false);
            }
        } else if (args[0].equals("--delete")) {
            admin.deleteChannel(args[1]);
        } else if (args[0].equals("--purge")) {
            admin.purge(args[1], Integer.parseInt(args[2]));
        } else if (args[0].equals("--repair")) {
            String ch = null;
            if (args.length == 3) {
                ch = args[2];
            }
            admin.repair(args[1], ch);
        }
    }
}

