/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston;

import gov.usgs.plot.Plot;
import gov.usgs.plot.Renderer;
import gov.usgs.util.Arguments;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.heli.plot.HelicorderRenderer;
import gov.usgs.winston.server.WWSClient;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;

public class PlotHelicorder {
    private String host;
    private int port;
    private Settings settings = new Settings();
    private Arguments args;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public PlotHelicorder(String[] a) {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (a.length == 0) {
            this.outputInstructions();
            System.exit(1);
        }
        HashSet flags = new HashSet();
        HashSet<String> kvs = new HashSet<String>();
        kvs.add("-wws");
        kvs.add("-s");
        kvs.add("-e");
        kvs.add("-m");
        kvs.add("-h");
        kvs.add("-tz");
        kvs.add("-to");
        kvs.add("-x");
        kvs.add("-y");
        kvs.add("-lm");
        kvs.add("-rm");
        kvs.add("-o");
        kvs.add("-c");
        kvs.add("-b");
        kvs.add("-r");
        this.args = new Arguments(a, flags, kvs);
        this.parseArgs();
        WWSClient winston = new WWSClient(this.host, this.port);
        System.out.print("getting data...");
        String[] scn = this.settings.station.split("_");
        HelicorderData heliData = winston.getHelicorder(scn[0], scn[1], scn[2], scn[3], this.settings.startTime, this.settings.endTime, true);
        winston.close();
        System.out.println("done.");
        HelicorderRenderer heliRenderer = new HelicorderRenderer();
        heliRenderer.setData(heliData);
        heliRenderer.setTimeChunk(this.settings.timeChunk);
        Plot plot = new Plot();
        plot.setSize(this.settings.xSize, this.settings.ySize);
        plot.addRenderer((Renderer)heliRenderer);
        heliRenderer.setLocation(this.settings.left, this.settings.top, this.settings.xSize - (this.settings.left + this.settings.right), this.settings.ySize - (this.settings.top + this.settings.bottom));
        double mean = heliData.getMeanMax();
        double bias = heliData.getBias();
        mean = Math.abs(bias - mean);
        if (this.settings.clipValue == -1) {
            this.settings.clipValue = (int)(21.0 * mean);
            System.out.println("Automatic clip value: " + this.settings.clipValue);
        }
        if (this.settings.barRange == -1) {
            this.settings.barRange = (int)(3.0 * mean);
            System.out.println("Automatic bar range: " + this.settings.barRange);
        }
        heliRenderer.setHelicorderExtents(this.settings.startTime, this.settings.endTime, (double)(-1 * Math.abs(this.settings.barRange)), (double)Math.abs(this.settings.barRange));
        heliRenderer.setClipValue(this.settings.clipValue);
        heliRenderer.setShowClip(this.settings.showClip);
        heliRenderer.setTimeZoneAbbr(this.settings.timeZoneAbbr);
        heliRenderer.setTimeZoneOffset(this.settings.timeZoneOffset);
        heliRenderer.createDefaultAxis();
        System.out.print("writing...");
        plot.writePNG(this.settings.outputFilename);
        System.out.println("done.");
    }

    public void outputInstructions() {
        System.out.println("Server/station/time options");
        System.out.println("-wws  [host]:[port], the WWS, mandatory argument");
        System.out.println("-s    station, mandatory argument");
        System.out.println("-e    end time [now], format: 'YYYYMMDDHHMMSS' (GMT) or 'now'");
        System.out.println("-m    minutes on x-axis [20]");
        System.out.println("-h    hours on y-axis [12]");
        System.out.println("-tz   time zone abbreviation [GMT]");
        System.out.println("-to   time zone offset, hours [0]");
        System.out.println();
        System.out.println("Output options");
        System.out.println("-x    total plot x-pixel size [1000]");
        System.out.println("-y    total plot y-pixel size [1000]");
        System.out.println("-lm   left margin pixels [70]");
        System.out.println("-rm   right margin pixels [70]");
        System.out.println("-o    output file name [heli.png]");
        System.out.println("-c    clip value, a number [auto]");
        System.out.println("-b    bar range, a number [auto]");
        System.out.println("-r    show clipped trace as red, 0 or 1 [0]");
    }

    public void error(String s) {
        System.out.println(s);
        System.exit(1);
    }

    public void parseArgs() {
        String[] hp = this.args.get("-wws").split(":");
        if (hp.length != 2) {
            this.error("You must specify a WWS as [host]:[port].");
        }
        this.host = hp[0];
        if (this.host == null) {
            this.error("You must specify a WWS host properly.");
        } else {
            System.out.println("host: " + this.host);
        }
        this.port = -1;
        try {
            this.port = Integer.parseInt(hp[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.port == -1) {
            this.error("You must specify a WWS port properly.");
        } else {
            System.out.println("port: " + this.port);
        }
        this.settings.station = this.args.get("-s");
        if (this.settings.station == null) {
            this.error("You must specify a station with -s.");
        } else {
            System.out.println("station: " + this.settings.station);
        }
        String s = this.args.get("-x");
        if (s != null) {
            int x = -1;
            try {
                x = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (x == -1) {
                this.error("Error with '-x' value.");
            }
            System.out.println("x-pixels: " + x);
            this.settings.xSize = x;
        }
        if ((s = this.args.get("-y")) != null) {
            int y = -1;
            try {
                y = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (y == -1) {
                this.error("Error with '-y' value.");
            }
            System.out.println("y-pixels: " + y);
            this.settings.ySize = y;
        }
        if ((s = this.args.get("-lm")) != null) {
            int lm = -1;
            try {
                lm = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (lm == -1) {
                this.error("Error with '-lm' value.");
            }
            System.out.println("left margin: " + lm);
            this.settings.left = lm;
        }
        if ((s = this.args.get("-rm")) != null) {
            int rm = -1;
            try {
                rm = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (rm == -1) {
                this.error("Error with '-rm' value.");
            }
            System.out.println("right margin: " + rm);
            this.settings.right = rm;
        }
        if ((s = this.args.get("-m")) != null) {
            int m = -1;
            try {
                m = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (m == -1) {
                this.error("Error with '-m' value.");
            }
            System.out.println("x-axis minutes: " + m);
            this.settings.timeChunk = m * 60;
        }
        if ((s = this.args.get("-h")) != null) {
            int h = -1;
            try {
                h = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (h == -1) {
                this.error("Error with '-h' value.");
            }
            System.out.println("y-axis hours: " + h);
            this.settings.hours = h;
        }
        if ((s = this.args.get("-o")) != null) {
            this.settings.outputFilename = s;
            System.out.println("output file: " + s);
        }
        if ((s = this.args.get("-tz")) != null) {
            this.settings.timeZoneAbbr = s;
            System.out.println("time zone abbreviation: " + s);
        }
        if ((s = this.args.get("-to")) != null) {
            double h = Double.NaN;
            try {
                h = Double.parseDouble(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (Double.isNaN(h)) {
                this.error("Error with '-tzo' value.");
            }
            System.out.println("time zone offset: " + h);
            this.settings.timeZoneOffset = h;
        }
        this.settings.endTime = CurrentTime.getInstance().nowJ2K();
        s = this.args.get("-e");
        if (s != null && !s.equals("now")) {
            Date date = null;
            try {
                date = this.dateFormat.parse(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (date == null) {
                this.error("Error with '-e' value.");
            }
            System.out.println("end time: " + s);
            this.settings.endTime = Util.dateToJ2K((Date)date);
        }
        if ((s = this.args.get("-c")) != null) {
            int c = -1;
            try {
                c = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (c == -1) {
                this.error("Error with '-c' value.");
            }
            System.out.println("clip value: " + c);
            this.settings.clipValue = c;
        }
        if ((s = this.args.get("-b")) != null) {
            int b = -1;
            try {
                b = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (b == -1) {
                this.error("Error with '-b' value.");
            }
            System.out.println("bar range: " + b);
            this.settings.barRange = b;
        }
        if ((s = this.args.get("-r")) != null) {
            this.settings.showClip = s.equals("1");
            System.out.println("show clip: " + this.settings.showClip);
        }
        this.settings.startTime = this.settings.endTime - (double)(this.settings.hours * 60 * 60);
        this.settings.startTime -= this.settings.startTime % this.settings.timeChunk;
    }

    public static void main(String[] args) {
        new PlotHelicorder(args);
    }

    class Settings {
        String station;
        double timeChunk = 1200.0;
        double endTime;
        double startTime;
        int hours = 12;
        int xSize = 1000;
        int ySize = 1000;
        int left = 70;
        int top = 20;
        int right = 70;
        int bottom = 50;
        int clipValue = -1;
        int barRange = -1;
        boolean showClip = false;
        String timeZoneAbbr = "GMT";
        double timeZoneOffset = 0.0;
        String outputFilename = "heli.png";

        Settings() {
        }
    }
}

