/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.writer.relaxng;

import com.sun.msv.driver.textui.DebugController;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.util.GrammarLoader;
import com.sun.msv.writer.relaxng.RELAXNGWriter;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class Driver {
    private static final String MSG_USAGE = "Driver.Usage";
    private static final String MSG_GRAMMAR_ERROR = "Driver.GrammarError";

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println(Driver.localize(MSG_USAGE));
            return;
        }
        SAXParserFactoryImpl sAXParserFactoryImpl = new SAXParserFactoryImpl();
        sAXParserFactoryImpl.setNamespaceAware(true);
        Grammar grammar = GrammarLoader.loadSchema((String)stringArray[0], (GrammarReaderController)new DebugController(false, false, System.err), (SAXParserFactory)sAXParserFactoryImpl);
        if (grammar == null) {
            System.err.println(Driver.localize(MSG_GRAMMAR_ERROR));
            return;
        }
        Driver.writeGrammar(grammar, System.out);
    }

    public static void writeGrammar(Grammar grammar, OutputStream outputStream) throws SAXException {
        RELAXNGWriter rELAXNGWriter = new RELAXNGWriter();
        rELAXNGWriter.setDocumentHandler((DocumentHandler)new XMLSerializer(outputStream, new OutputFormat("xml", null, true)));
        rELAXNGWriter.write(grammar);
    }

    public static String localize(String string, Object[] objectArray) {
        String string2 = ResourceBundle.getBundle("com.sun.msv.writer.relaxng.Messages").getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    public static String localize(String string) {
        return Driver.localize(string, null);
    }

    public static String localize(String string, Object object) {
        return Driver.localize(string, new Object[]{object});
    }

    public static String localize(String string, Object object, Object object2) {
        return Driver.localize(string, new Object[]{object, object2});
    }
}

