/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.bag;

import com.martiansoftware.jsap.ParseException;
import edu.iris.Fissures.Area;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfEvent.EventFinder;
import edu.iris.Fissures.IfEvent.EventSeqIterHolder;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitRange;
import edu.iris.Fissures.model.BoxAreaImpl;
import edu.iris.Fissures.model.GlobalAreaImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.PointDistanceAreaImpl;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.bag.AbstractGrabber;
import edu.sc.seis.bag.EventResultIterator;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import java.util.Iterator;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGrabber
extends AbstractGrabber
implements Iterable {
    EventFinder finder;
    private static final Logger logger = LoggerFactory.getLogger(EventGrabber.class);
    private TimeRange timeRange;
    private UnitRange depthRange;
    private Area area;
    private float minMag;
    private float maxMag;
    private String[] catalogs;
    private String[] contributors;
    private String[] magTypes;

    public EventGrabber() throws NotFound, CannotProceed, InvalidName {
        this("edu/iris/dmc", "IRIS_EventDC");
    }

    public EventGrabber(String serverDNS, String serverName) throws NotFound, CannotProceed, InvalidName {
        this.finder = BulletproofVestFactory.vestEventDC((String)serverDNS, (String)serverName, (FissuresNamingService)namingService).a_finder();
        MicroSecondDate now = ClockUtil.now();
        MicroSecondDate oneWeekAgo = now.subtract(new TimeInterval(7.0, UnitImpl.DAY));
        this.timeRange = new TimeRange(oneWeekAgo.getFissuresTime(), now.getFissuresTime());
        this.area = new GlobalAreaImpl();
        this.depthRange = new UnitRangeImpl(0.0, 1000.0, (Unit)UnitImpl.KILOMETER);
        this.magTypes = new String[0];
        this.minMag = -9.0f;
        this.maxMag = 10.0f;
        this.catalogs = new String[0];
        this.contributors = new String[0];
    }

    public Iterator iterator() {
        EventSeqIterHolder iter = new EventSeqIterHolder();
        EventAccess[] events = this.finder.query_events(this.area, (Quantity)new QuantityImpl(this.depthRange.min_value, this.depthRange.the_units), (Quantity)new QuantityImpl(this.depthRange.max_value, this.depthRange.the_units), this.timeRange, this.magTypes, this.minMag, this.maxMag, this.catalogs, this.contributors, 500, iter);
        return new EventResultIterator(events, iter.value);
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public void setBoxArea(float minLon, float maxLon, float minLat, float maxLat) {
        this.setArea((Area)new BoxAreaImpl(minLat, maxLat, minLon, maxLon));
    }

    public void setDoughnutArea(float lat, float lon, float minDegree, float maxDegree) {
        this.setArea((Area)new PointDistanceAreaImpl(lat, lon, (Quantity)new QuantityImpl((double)minDegree, (Unit)UnitImpl.DEGREE), (Quantity)new QuantityImpl((double)maxDegree, (Unit)UnitImpl.DEGREE)));
    }

    public String[] getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(String catalog) {
        this.setCatalogs(new String[]{catalog});
    }

    public void setCatalogs(String[] catalogs) {
        this.catalogs = catalogs;
    }

    public String[] getContributors() {
        return this.contributors;
    }

    public void setContributors(String contributor) {
        this.setContributors(new String[]{contributor});
    }

    public void setContributors(String[] contributors) {
        this.contributors = contributors;
    }

    public UnitRange getDepthRange() {
        return this.depthRange;
    }

    public void setDepthRange(UnitRange depthRange) {
        this.depthRange = depthRange;
    }

    public void setDepthRange(float min, float max) {
        this.setDepthRange((UnitRange)new UnitRangeImpl((double)min, (double)max, (Unit)UnitImpl.KILOMETER));
    }

    public String[] getMagTypes() {
        return this.magTypes;
    }

    public void setMagTypes(String[] magTypes) {
        this.magTypes = magTypes;
    }

    public float getMaxMag() {
        return this.maxMag;
    }

    public void setMaxMag(float maxMag) {
        this.maxMag = maxMag;
    }

    public float getMinMag() {
        return this.minMag;
    }

    public void setMinMag(float minMag) {
        this.minMag = minMag;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public void setTimeRange(String begin, String end) throws ParseException {
        TimeRange tr = new TimeRange();
        tr.start_time = this.getTimeFromString(begin);
        tr.end_time = this.getTimeFromString(end);
        this.setTimeRange(tr);
    }

    public Time getTimeFromString(String t) throws ParseException {
        if (t.equalsIgnoreCase("now")) {
            return ClockUtil.now().getFissuresTime();
        }
        if (t.equalsIgnoreCase("yesterday")) {
            return ClockUtil.now().subtract(new TimeInterval(1.0, UnitImpl.DAY)).getFissuresTime();
        }
        if (t.equalsIgnoreCase("weekAgo")) {
            return ClockUtil.now().subtract(new TimeInterval(1.0, UnitImpl.WEEK)).getFissuresTime();
        }
        if (t.equalsIgnoreCase("monthAgo")) {
            return ClockUtil.now().subtract(new TimeInterval(31.0, UnitImpl.DAY)).getFissuresTime();
        }
        if (t.equalsIgnoreCase("yearAgo")) {
            return ClockUtil.now().subtract(new TimeInterval(1.0, UnitImpl.GREGORIAN_YEAR)).getFissuresTime();
        }
        return new Time(t, -1);
    }
}

