/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.bag;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.sc.seis.bag.AbstractGrabber;
import edu.sc.seis.fissuresUtil.cache.VestingNetworkDC;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class ChannelGrabber
extends AbstractGrabber
implements Iterable {
    NetworkFinder finder;
    String netCode = "IU";
    String staCode = "ANMO";
    String siteCode = "00";
    String chanCode = "BHZ";

    public ChannelGrabber() throws NotFound, CannotProceed, InvalidName {
        this("edu/iris/dmc", "IRIS_NetworkDC");
    }

    public ChannelGrabber(String serverDNS, String serverName, String netCode, String staCode, String siteCode, String chanCode) throws NotFound, CannotProceed, InvalidName {
        this(serverDNS, serverName);
        this.setNetCode(netCode);
        this.setStaCode(staCode);
        this.setSiteCode(siteCode);
        this.setChanCode(chanCode);
    }

    public ChannelGrabber(String netCode, String staCode, String siteCode, String chanCode) throws NotFound, CannotProceed, InvalidName {
        this();
        this.setNetCode(netCode);
        this.setStaCode(staCode);
        this.setSiteCode(siteCode);
        this.setChanCode(chanCode);
    }

    public ChannelGrabber(String serverDNS, String serverName) throws NotFound, CannotProceed, InvalidName {
        VestingNetworkDC netDC = new VestingNetworkDC(serverDNS, serverName, namingService);
        this.finder = netDC.a_finder();
    }

    public Iterator iterator() {
        ArrayList<Channel> out = new ArrayList<Channel>();
        try {
            NetworkAccess[] nets = this.finder.retrieve_by_code(this.netCode);
            for (int n = 0; n < nets.length; ++n) {
                Channel[] chans = nets[n].retrieve_channels_by_code(this.staCode, this.siteCode, this.chanCode);
                for (int c = 0; c < chans.length; ++c) {
                    out.add(chans[c]);
                }
            }
        }
        catch (NetworkNotFound e) {
        }
        catch (ChannelNotFound channelNotFound) {
            // empty catch block
        }
        return out.iterator();
    }

    public String getChanCode() {
        return this.chanCode;
    }

    public void setChanCode(String chanCode) {
        this.chanCode = chanCode;
    }

    public String getNetCode() {
        return this.netCode;
    }

    public void setNetCode(String netCode) {
        this.netCode = netCode;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getStaCode() {
        return this.staCode;
    }

    public void setStaCode(String staCode) {
        this.staCode = staCode;
    }
}

