/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.winston.WinstonUtil;

public class WinstonSCNL {
    static final String SEP = "$";
    String station;
    String channel;
    String network;
    String locId;
    String prefix;

    protected WinstonSCNL(String databaseName, String prefix) {
        this.prefix = prefix;
        String woPrefix = databaseName.substring(prefix.length() + 1);
        String[] s = woPrefix.split("\\$");
        if (s.length == 4) {
            this.locId = s[3];
        } else {
            if (s.length != 3) {
                throw new IllegalArgumentException("Invalid Winston database name: '" + databaseName + "', must have 2 or 3 $'s");
            }
            this.locId = null;
        }
        this.station = s[0];
        this.channel = s[1];
        this.network = s[2];
    }

    protected WinstonSCNL(String station, String channel, String network, String locId, String prefix) {
        this.station = station;
        this.channel = channel;
        this.network = network;
        this.locId = locId;
        this.prefix = prefix;
    }

    public String getDatabaseName() {
        return WinstonUtil.prefixTableName(this.prefix, this.concatSCNL());
    }

    public String concatSCNL() {
        return this.station + SEP + this.channel + SEP + this.network + (this.locId != null && this.locId.trim().length() != 0 ? SEP + this.locId : "");
    }

    public String getStation() {
        return this.station;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getLocId() {
        return this.locId;
    }
}

