/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.syncFile.SyncFileWriter;
import edu.sc.seis.seisFile.winston.TraceBuf2;
import edu.sc.seis.seisFile.winston.WinstonSCNL;
import edu.sc.seis.seisFile.winston.WinstonUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;

public class WinstonClient {
    QueryParams params;
    Properties winstonConfig = new Properties();
    boolean doSync = false;
    int recordSize = 12;
    boolean doSteim1 = false;

    protected WinstonClient(String[] args) throws SeisFileException, FileNotFoundException, IOException {
        this.params = new QueryParams(args);
        this.winstonConfig.put("winston.driver", "com.mysql.jdbc.Driver");
        this.winstonConfig.put("winston.prefix", "W");
        this.winstonConfig.put("winston.url", "jdbc:mysql://localhost/?user=wwsuser");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--sync")) {
                this.doSync = true;
                continue;
            }
            if (args[i].equals("--steim1")) {
                this.doSteim1 = true;
                continue;
            }
            if (i >= args.length - 1) continue;
            if (args[i].equals("-p")) {
                this.winstonConfig.load(new BufferedReader(new FileReader(args[i + 1])));
                continue;
            }
            if (args[i].equals("-u")) {
                this.winstonConfig.put("winston.url", args[i + 1]);
                continue;
            }
            if (!args[i].equals("--recLen")) continue;
            this.recordSize = Integer.parseInt(args[i + 1]);
        }
        if (!this.doSync && this.params.getOutFile() == null) {
            this.params.setOutFile("output.mseed");
        }
    }

    public static void main(String[] args) throws Exception {
        WinstonClient client = new WinstonClient(args);
        client.readData();
    }

    public void readData() throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        if (this.params.isPrintHelp()) {
            System.out.println(this.getHelp());
            return;
        }
        if (this.params.isPrintVersion()) {
            System.out.println("Version: " + BuildVersion.getDetailedVersion());
            return;
        }
        if (this.params.getNetwork() == null || this.params.getStation() == null || this.params.getChannel() == null) {
            System.out.println(BuildVersion.getDetailedVersion() + " one of scnl is null: n=" + this.params.getNetwork() + " s=" + this.params.getStation() + " l=" + this.params.getLocation() + " c=" + this.params.getChannel());
            System.out.println("LocId null is ok for scn, but needed for scnl");
            return;
        }
        if (this.params.isVerbose()) {
            WinstonUtil.setVerbose(true);
        }
        WinstonUtil winston = new WinstonUtil(this.getDbURL(), this.getUser(), this.getPassword(), this.winstonConfig.getProperty("winston.prefix"));
        List<WinstonSCNL> allChannels = winston.listChannelDatabases();
        Pattern staPattern = Pattern.compile("*".equals(this.params.getStation()) ? ".*" : this.params.getStation());
        Pattern chanPattern = Pattern.compile("*".equals(this.params.getChannel()) ? ".*" : this.params.getChannel());
        Pattern netPattern = Pattern.compile("*".equals(this.params.getNetwork()) ? ".*" : this.params.getNetwork());
        Pattern locPattern = Pattern.compile("*".equals(this.params.getLocation()) ? ".*" : this.params.getLocation());
        if (this.doSync) {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.params.getDataOutputStream())));
            SyncFileWriter syncOut = new SyncFileWriter("winston", out);
            for (WinstonSCNL scnl : allChannels) {
                if (!staPattern.matcher(scnl.getStation()).matches() || !chanPattern.matcher(scnl.getChannel()).matches() || !netPattern.matcher(scnl.getNetwork()).matches() || !locPattern.matcher(scnl.getLocId()).matches()) continue;
                this.syncChannel(winston, scnl, syncOut);
            }
            syncOut.close();
        } else {
            for (WinstonSCNL scnl : allChannels) {
                if (!staPattern.matcher(scnl.getStation()).matches() || !chanPattern.matcher(scnl.getChannel()).matches() || !netPattern.matcher(scnl.getNetwork()).matches() || !locPattern.matcher(scnl.getLocId()).matches()) continue;
                this.processChannel(winston, scnl);
            }
            this.params.getDataOutputStream().close();
        }
        winston.close();
    }

    void syncChannel(WinstonUtil winston, WinstonSCNL channel, SyncFileWriter syncOut) throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTime(this.params.getBegin());
        int startYear = cal.get(1);
        int startMonth = cal.get(2) + 1;
        int startDay = cal.get(5);
        cal.setTime(this.params.getEnd());
        int endYear = cal.get(1);
        int endMonth = cal.get(2) + 1;
        int endDay = cal.get(5);
        winston.writeSyncBetweenDates(channel, startYear, startMonth, startDay, endYear, endMonth, endDay, syncOut);
    }

    void processChannel(WinstonUtil winston, WinstonSCNL channel) throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        List<TraceBuf2> tbList = winston.extractData(channel, this.params.getBegin(), this.params.getEnd());
        for (TraceBuf2 traceBuf2 : tbList) {
            DataRecord mseed = traceBuf2.toMiniSeed(this.recordSize, this.doSteim1);
            mseed.write(this.params.getDataOutputStream());
        }
    }

    String getDbURL() {
        return this.winstonConfig.getProperty("winston.url");
    }

    String getUser() throws URISyntaxException, SeisFileException {
        return this.getUrlQueryParam("user");
    }

    String getPassword() throws URISyntaxException, SeisFileException {
        return this.getUrlQueryParam("password");
    }

    String getUrlQueryParam(String name) throws SeisFileException, URISyntaxException {
        String[] urlParts = this.getDbURL().split("\\?")[1].split("\\&");
        for (int i = 0; i < urlParts.length; ++i) {
            if (!urlParts[i].startsWith(name + "=")) continue;
            return urlParts[i].substring((name + "=").length());
        }
        throw new SeisFileException("Unable to find '" + name + "' query param in database url: " + this.getDbURL());
    }

    public String getHelp() {
        return "java " + WinstonClient.class.getName() + " " + QueryParams.getStandardHelpOptions() + "[-p <winston.config file>][-u databaseURL][--sync][--steim1][--recLen len(8-12)]";
    }
}

