/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.Steim1;
import edu.iris.dmc.seedcodec.SteimException;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TraceBuf2 {
    int pin;
    int numSamples;
    double startTime;
    double endTime;
    double sampleRate;
    String station;
    String network;
    String channel;
    String locId;
    String version;
    String dataType;
    String quality;
    String pad;
    short[] shortData;
    int[] intData;
    float[] floatData;
    double[] doubleData;
    public static final String LOC_NULL_STRING = "--";
    public static final int MAX_TRACEBUF_SIZE = 4096;
    public static final int AMPLIFIER_SATURATED = 1;
    public static final int DIGITIZER_CLIPPED = 2;
    public static final int SPIKES_DETECTED = 4;
    public static final int GLITCHES_DETECTED = 8;
    public static final int MISSING_DATA_PRESENT = 16;
    public static final int TELEMETRY_SYNCH_ERROR = 32;
    public static final int FILTER_CHARGING = 64;
    public static final int TIME_TAG_QUESTIONABLE = 128;
    public static final String SUN_IEEE_SINGLE_PRECISION_REAL = "t4";
    public static final String SUN_IEEE_DOUBLE_PRECISION_REAL = "t8";
    public static final String SUN_IEEE_INTEGER = "s4";
    public static final String SUN_IEEE_SHORT_INTEGER = "s2";
    public static final String INTEL_IEEE_SINGLE_PRECISION_REAL = "f4";
    public static final String INTEL_IEEE_DOUBLE_PRECISION_REAL = "f8";
    public static final String INTEL_IEEE_INTEGER = "i4";
    public static final String INTEL_IEEE_SHORT_INTEGER = "i2";
    public static final String NORESS_GAIN_RANGED = "g2";

    public TraceBuf2(byte[] data) {
        this.dataType = TraceBuf2.extractDataType(data);
        boolean swapBytes = TraceBuf2.isSwapBytes(this.dataType);
        this.pin = Utility.bytesToInt(data, 0, swapBytes);
        this.numSamples = TraceBuf2.extractNumSamples(data, swapBytes);
        this.startTime = Utility.bytesToDouble(data, 8, swapBytes);
        this.endTime = Utility.bytesToDouble(data, 16, swapBytes);
        this.sampleRate = Utility.bytesToDouble(data, 24, swapBytes);
        this.station = Utility.extractNullTermString(data, 32, 7);
        this.network = Utility.extractNullTermString(data, 39, 9);
        this.channel = Utility.extractNullTermString(data, 48, 4);
        this.locId = Utility.extractNullTermString(data, 52, 3);
        this.version = Utility.extractString(data, 55, 2);
        this.dataType = Utility.extractNullTermString(data, 57, 3);
        this.quality = Utility.extractString(data, 60, 2);
        this.pad = Utility.extractString(data, 62, 2);
        int offset = 64;
        if (this.isShortData()) {
            this.shortData = new short[this.numSamples];
            for (int i = 0; i < this.shortData.length; ++i) {
                this.shortData[i] = Utility.bytesToShort(data[offset], data[offset + 1], swapBytes);
                offset += 2;
            }
        } else if (this.isIntData()) {
            this.intData = new int[this.numSamples];
            for (int i = 0; i < this.intData.length; ++i) {
                this.intData[i] = Utility.bytesToInt(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], swapBytes);
                offset += 4;
            }
        } else if (this.isFloatData()) {
            this.floatData = new float[this.numSamples];
            for (int i = 0; i < this.floatData.length; ++i) {
                this.floatData[i] = Utility.bytesToFloat(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], swapBytes);
                offset += 4;
            }
        } else if (this.isDoubleData()) {
            this.doubleData = new double[this.numSamples];
            for (int i = 0; i < this.doubleData.length; ++i) {
                this.doubleData[i] = Utility.bytesToDouble(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], data[offset + 4], data[offset + 5], data[offset + 6], data[offset + 7], swapBytes);
                offset += 8;
            }
        } else {
            if (this.dataType.equals(NORESS_GAIN_RANGED)) {
                throw new RuntimeException("NORESS gain-ranged data type not supported: " + this.dataType);
            }
            throw new RuntimeException("Unknown data type: " + this.dataType);
        }
    }

    public static int extractNumSamples(byte[] data, boolean swapBytes) {
        return Utility.bytesToInt(data, 4, swapBytes);
    }

    public static String extractDataType(byte[] data) {
        return Utility.extractNullTermString(data, 57, 3);
    }

    public static boolean isSwapBytes(String dataType) {
        return dataType.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL) || dataType.equals(INTEL_IEEE_INTEGER) || dataType.equals(INTEL_IEEE_SHORT_INTEGER) || dataType.equals(INTEL_IEEE_SINGLE_PRECISION_REAL);
    }

    public static int getSampleSize(String dataType) {
        if (TraceBuf2.isShortData(dataType)) {
            return 2;
        }
        if (TraceBuf2.isIntData(dataType) || TraceBuf2.isFloatData(dataType)) {
            return 4;
        }
        if (TraceBuf2.isDoubleData(dataType)) {
            return 8;
        }
        throw new RuntimeException("Unknown dataType: '" + dataType + "'");
    }

    public boolean isShortData() {
        return TraceBuf2.isShortData(this.dataType);
    }

    public boolean isIntData() {
        return TraceBuf2.isIntData(this.dataType);
    }

    public boolean isFloatData() {
        return TraceBuf2.isFloatData(this.dataType);
    }

    public boolean isDoubleData() {
        return TraceBuf2.isDoubleData(this.dataType);
    }

    public static boolean isShortData(String dataType) {
        return dataType.equals(INTEL_IEEE_SHORT_INTEGER) || dataType.equals(SUN_IEEE_SHORT_INTEGER);
    }

    public static boolean isIntData(String dataType) {
        return dataType.equals(INTEL_IEEE_INTEGER) || dataType.equals(SUN_IEEE_INTEGER);
    }

    public static boolean isFloatData(String dataType) {
        return dataType.equals(INTEL_IEEE_SINGLE_PRECISION_REAL) || dataType.equals(SUN_IEEE_SINGLE_PRECISION_REAL);
    }

    public static boolean isDoubleData(String dataType) {
        return dataType.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL) || dataType.equals(SUN_IEEE_DOUBLE_PRECISION_REAL);
    }

    public int getPin() {
        return this.pin;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public Date getStartDate() {
        return new Date(Math.round(this.getStartTime() * 1000.0));
    }

    public Date getEndDate() {
        return new Date(Math.round(this.getEndTime() * 1000.0));
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public String getStation() {
        return this.station;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getLocId() {
        return this.locId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getQuality() {
        return this.quality;
    }

    public String getPad() {
        return this.pad;
    }

    public short[] getShortData() {
        return this.shortData;
    }

    public int[] getIntData() {
        if (this.isIntData()) {
            return this.intData;
        }
        if (this.isShortData()) {
            int[] out = new int[this.shortData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.shortData[i];
            }
            return out;
        }
        return null;
    }

    public float[] getFloatData() {
        if (this.isFloatData()) {
            return this.floatData;
        }
        if (this.isIntData()) {
            float[] out = new float[this.intData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.intData[i];
            }
            return out;
        }
        if (this.isShortData()) {
            float[] out = new float[this.shortData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.shortData[i];
            }
            return out;
        }
        return null;
    }

    public double[] getDoubleData() {
        if (this.isDoubleData()) {
            return this.doubleData;
        }
        if (this.isFloatData()) {
            double[] out = new double[this.floatData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.floatData[i];
            }
            return out;
        }
        if (this.isIntData()) {
            double[] out = new double[this.intData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.intData[i];
            }
            return out;
        }
        if (this.isShortData()) {
            double[] out = new double[this.shortData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.shortData[i];
            }
            return out;
        }
        return null;
    }

    public byte getSeedEncoding() {
        if (this.dataType.equals(SUN_IEEE_INTEGER) || this.dataType.equals(INTEL_IEEE_INTEGER)) {
            return 3;
        }
        if (this.dataType.equals(SUN_IEEE_SHORT_INTEGER) || this.dataType.equals(INTEL_IEEE_SHORT_INTEGER)) {
            return 1;
        }
        if (this.dataType.equals(SUN_IEEE_SINGLE_PRECISION_REAL) || this.dataType.equals(INTEL_IEEE_SINGLE_PRECISION_REAL)) {
            return 4;
        }
        if (this.dataType.equals(SUN_IEEE_DOUBLE_PRECISION_REAL) || this.dataType.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL)) {
            return 5;
        }
        throw new RuntimeException("Unknown dataType: " + this.dataType);
    }

    public DataRecord toMiniSeed() throws SeedFormatException {
        return this.toMiniSeed(12, false);
    }

    public DataRecord toMiniSeed(int recLen, boolean steim1) throws SeedFormatException {
        DataHeader dh = new DataHeader(0, 'D', false);
        dh.setStationIdentifier(this.getStation());
        dh.setChannelIdentifier(this.getChannel());
        dh.setNetworkCode(this.getNetwork());
        String l = this.getLocId();
        if (l == null || l.equals(LOC_NULL_STRING)) {
            l = "  ";
        }
        dh.setLocationIdentifier(l);
        dh.setDataQualityFlags((byte)this.getQuality().charAt(0));
        dh.setNumSamples((short)this.getNumSamples());
        dh.setStartBtime(new Btime(this.getStartDate()));
        dh.setSampleRate(this.getSampleRate());
        DataRecord dr = new DataRecord(dh);
        Blockette1000 b1000 = new Blockette1000();
        if (steim1) {
            b1000.setEncodingFormat((byte)10);
        } else {
            b1000.setEncodingFormat(this.getSeedEncoding());
        }
        b1000.setDataRecordLength((byte)recLen);
        b1000.setWordOrder((byte)1);
        dr.addBlockette(b1000);
        Codec codec = new Codec();
        byte[] dataBytes = new byte[]{};
        if (steim1) {
            try {
                if (!this.isShortData() && !this.isIntData()) {
                    throw new SeedFormatException("Steim1 only applicable to integer data, not float or double: " + this.getDataType());
                }
                dataBytes = Steim1.encode((int[])this.getIntData(), (int)((1 << recLen) / 64 - 1)).getEncodedData();
            }
            catch (SteimException e) {
                throw new SeedFormatException(e);
            }
            catch (IOException e) {
                throw new SeedFormatException(e);
            }
        } else if (this.isShortData()) {
            dataBytes = codec.encodeAsBytes(this.getShortData());
        } else if (this.isIntData()) {
            dataBytes = codec.encodeAsBytes(this.getIntData());
        } else if (this.isFloatData()) {
            dataBytes = codec.encodeAsBytes(this.getFloatData());
        } else if (this.isDoubleData()) {
            dataBytes = codec.encodeAsBytes(this.getDoubleData());
        }
        if ((double)(dh.getSize() + b1000.getSize() + dataBytes.length) > Math.pow(2.0, recLen)) {
            throw new SeedFormatException("Cannot fit data into record lenght of " + recLen + "(" + Math.pow(2.0, recLen) + "). header=" + (dh.getSize() + b1000.getSize()) + " data=" + dataBytes.length);
        }
        dr.setData(dataBytes);
        return dr;
    }

    public int getSize() {
        return 64 + this.getNumSamples() * TraceBuf2.getSampleSize(this.getDataType());
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this.getPin() + " " + this.network + "." + this.station + "." + this.locId + "." + this.channel + " " + sdf.format(this.getStartDate()) + "(" + this.getStartTime() + ") to " + sdf.format(this.getEndDate()) + "(" + this.getEndTime() + ") sr=" + this.getSampleRate() + "  npts=" + this.numSamples + " datetype=" + this.getDataType() + " ver=" + this.getVersion();
    }

    public String toStringWithData() {
        String out = this.toString() + "\n";
        if (this.isShortData() || this.isIntData()) {
            int[] d = this.getIntData();
            for (int i = 0; i < d.length; ++i) {
                out = out + d[i] + " ";
                if (i % 8 != 7) continue;
                out = out + "\n";
            }
        } else {
            double[] d = this.getDoubleData();
            for (int i = 0; i < d.length; ++i) {
                out = out + d[i] + " ";
                if (i % 8 != 7) continue;
                out = out + "\n";
            }
        }
        return out;
    }
}

