/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.usgsCWB;

import edu.sc.seis.seisFile.MSeedQueryClient;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.usgsCWB.CWBReader;

public class Client
extends MSeedQueryClient {
    protected Client(String[] args) throws SeisFileException {
        super(args);
        String host = "cwb-pub.cr.usgs.gov";
        int port = 2061;
        int timeoutSec = 120;
        for (int i = 0; i < args.length; ++i) {
            if (i >= args.length - 1) continue;
            if (args[i].equals("-h")) {
                host = args[i + 1];
                continue;
            }
            if (args[i].equals("-p")) {
                port = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (!args[i].equals("--timeout")) continue;
            timeoutSec = Integer.parseInt(args[i + 1]);
        }
        this.reader = new CWBReader(host, port, timeoutSec * 1000);
    }

    public static void main(String[] args) throws Exception {
        Client client = new Client(args);
        client.readData();
    }

    @Override
    public String getHelp() {
        return "java " + Client.class.getName() + " " + QueryParams.getStandardHelpOptions() + "[-h host][-p port][--timeout sec]";
    }
}

