/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.SeisFileException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SyncLine
implements Comparable<SyncLine> {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy,DDD,HH:mm:ss");
    private static final DateFormat dateFormatFracSeconds = new SimpleDateFormat("yyyy,DDD,HH:mm:ss.SSS");
    private static final DateFormat dayOnlyDateFormat = new SimpleDateFormat("yyyy,DDD");
    String net;
    String sta;
    String loc;
    String chan;
    Date startTime;
    Date endTime;
    Float maxClockDrift;
    Float samplesPerSecond;
    String channelFlag;
    String stationVolume;
    String dccTapeNumber;
    String dmcTabpNumber;
    String comment;
    Date lineModByDMC;
    Date lineModByDCC;

    public static SyncLine parse(String line) throws SeisFileException {
        try {
            String[] s = line.split("\\|", -1);
            SyncLine out = new SyncLine(s[0], s[1], s[2], s[3], SyncLine.stringToDate(s[4]), SyncLine.stringToDate(s[5]), SyncLine.stringToFloat(s[6]), SyncLine.stringToFloat(s[7]), s[8], s[9], s[10], s[11], s[12], SyncLine.stringToDate(s[13]), SyncLine.stringToDate(s[14]));
            if (out.getStartTime().after(out.getEndTime())) {
                throw new SeisFileException("Start is after End: " + s[4] + " " + s[5]);
            }
            return out;
        }
        catch (Exception e) {
            throw new SeisFileException("Trouble parsing line: " + line, e);
        }
    }

    public SyncLine(SyncLine copy, Date startTime, Date endTime, Float samplesPerSecond) {
        this(copy, startTime, endTime);
        this.samplesPerSecond = samplesPerSecond;
    }

    public SyncLine(SyncLine copy, Date startTime, Date endTime) {
        this(copy.net, copy.sta, copy.loc, copy.chan, startTime, endTime, copy.maxClockDrift, copy.samplesPerSecond, copy.channelFlag, copy.stationVolume, copy.dccTapeNumber, copy.dmcTabpNumber, copy.comment, copy.lineModByDMC, copy.lineModByDCC);
    }

    public SyncLine(String net, String sta, String loc, String chan, Date startTime, Date endTime, Float maxClockDrift, Float samplesPerSecond) {
        this(net, sta, loc, chan, startTime, endTime, maxClockDrift, samplesPerSecond, "", "", "", "", "", null, null);
    }

    public SyncLine(String net, String sta, String loc, String chan) {
        this(net, sta, loc, chan, null, null, null, null);
    }

    public SyncLine(String net, String sta, String loc, String chan, Date startTime, Date endTime, Float maxClockDrift, Float samplesPerSecond, String channelFlag, String stationVolume, String dccTapeNumber, String dmcTabpNumber, String comment, Date lineModByDMC, Date lineModByDCC) {
        this.net = net;
        this.sta = sta;
        this.loc = loc;
        this.chan = chan;
        this.startTime = startTime;
        this.endTime = endTime;
        this.maxClockDrift = maxClockDrift;
        this.samplesPerSecond = samplesPerSecond;
        this.channelFlag = channelFlag;
        this.stationVolume = stationVolume;
        this.dccTapeNumber = dccTapeNumber;
        this.dmcTabpNumber = dmcTabpNumber;
        this.comment = comment;
        this.lineModByDMC = lineModByDMC;
        this.lineModByDCC = lineModByDCC;
    }

    public String toString() {
        return this.formatLine();
    }

    public String formatLine() {
        return SyncLine.concatWithSeparator(new String[]{this.net, this.sta, this.loc, this.chan, SyncLine.dateToString(this.startTime), SyncLine.dateToString(this.endTime), this.maxClockDrift == null ? "" : "" + this.maxClockDrift, this.samplesPerSecond == null ? "" : "" + this.samplesPerSecond, this.channelFlag, this.stationVolume, this.dccTapeNumber, this.dmcTabpNumber, this.comment, SyncLine.dateToString(this.lineModByDMC), SyncLine.dateToString(this.lineModByDCC)}, "|");
    }

    public boolean isContiguous(SyncLine line, float tolerenceSeconds) {
        return this.net.equals(line.net) && this.sta.equals(line.sta) && (this.loc == null && line.loc == null || this.loc != null && this.loc.equals(line.loc)) && this.chan.equals(line.chan) && Math.abs((double)(line.startTime.getTime() - this.endTime.getTime()) / 1000.0) <= (double)tolerenceSeconds;
    }

    public SyncLine concat(SyncLine after) {
        return new SyncLine(this, this.startTime, after.endTime);
    }

    @Override
    public int compareTo(SyncLine two) {
        int subComp = this.getNet().compareToIgnoreCase(two.getNet());
        if (subComp != 0) {
            return subComp;
        }
        subComp = this.getSta().compareToIgnoreCase(two.getSta());
        if (subComp != 0) {
            return subComp;
        }
        subComp = this.getLoc().compareToIgnoreCase(two.getLoc());
        if (subComp != 0) {
            return subComp;
        }
        subComp = this.getChan().compareToIgnoreCase(two.getChan());
        if (subComp != 0) {
            return subComp;
        }
        subComp = this.getStartTime().compareTo(two.getStartTime());
        if (subComp != 0) {
            return subComp;
        }
        return this.getEndTime().compareTo(two.getEndTime());
    }

    public SyncLine[] split(Date d) {
        if (d.before(this.getStartTime()) || d.after(this.getEndTime())) {
            return new SyncLine[]{this};
        }
        return new SyncLine[]{new SyncLine(this, this.getStartTime(), d), new SyncLine(this, d, this.getEndTime())};
    }

    public static String concatWithSeparator(String[] items, String separator) {
        String out = items[0];
        for (int i = 1; i < items.length; ++i) {
            out = out + separator;
            if (items[i] == null) continue;
            out = out + items[i].trim();
        }
        return out;
    }

    public static Float stringToFloat(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String d) throws ParseException {
        if (d == null || d.length() == 0) {
            return null;
        }
        if (d.length() == 8) {
            DateFormat dateFormat = dayOnlyDateFormat;
            synchronized (dateFormat) {
                return dayOnlyDateFormat.parse(d);
            }
        }
        if (d.length() > 17) {
            DateFormat dateFormat = dateFormatFracSeconds;
            synchronized (dateFormat) {
                return dateFormatFracSeconds.parse(d);
            }
        }
        DateFormat dateFormat = SyncLine.dateFormat;
        synchronized (dateFormat) {
            return SyncLine.dateFormat.parse(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToString(Date d) {
        if (d == null) {
            return "";
        }
        DateFormat dateFormat = dateFormatFracSeconds;
        synchronized (dateFormat) {
            return dateFormatFracSeconds.format(d);
        }
    }

    public String getNet() {
        return this.net;
    }

    public String getSta() {
        return this.sta;
    }

    public String getLoc() {
        return this.loc;
    }

    public String getChan() {
        return this.chan;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Float getMaxClockDrift() {
        return this.maxClockDrift;
    }

    public Float getSamplesPerSecond() {
        return this.samplesPerSecond;
    }

    public String getChannelFlag() {
        return this.channelFlag;
    }

    public String getStationVolume() {
        return this.stationVolume;
    }

    public String getDccTapeNumber() {
        return this.dccTapeNumber;
    }

    public String getDmcTabpNumber() {
        return this.dmcTabpNumber;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getLineModByDMC() {
        return this.lineModByDMC;
    }

    public Date getLineModByDCC() {
        return this.lineModByDCC;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormatFracSeconds.setTimeZone(TimeZone.getTimeZone("GMT"));
        dayOnlyDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

