/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import java.util.Iterator;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StaxUtil {
    public static StartElement expectStartElement(String expected, XMLEventReader reader) throws XMLStreamException, StationXMLException {
        XMLEvent cur = reader.peek();
        if (cur.isStartElement() && cur.asStartElement().getName().getLocalPart().equals(expected)) {
            return reader.nextEvent().asStartElement();
        }
        Location loc = cur.getLocation();
        throw new StationXMLException("Expected a start <" + expected + "> element at line " + loc.getLineNumber() + ", " + loc.getColumnNumber() + ": " + (cur.isStartElement() ? cur.asStartElement().getName().getLocalPart() : Integer.valueOf(cur.getEventType())));
    }

    public static String pullText(XMLEventReader reader, String elementName) throws XMLStreamException, StationXMLException {
        String outText = "";
        XMLEvent startElement = reader.nextEvent();
        if (startElement.isStartElement() && startElement.asStartElement().getName().getLocalPart().equals(elementName)) {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isCharacters()) {
                    outText = outText + e.asCharacters().getData();
                    continue;
                }
                if (!e.isEndElement()) continue;
                return outText;
            }
            throw new StationXMLException("Ran out of XMLEvents before end of text element");
        }
        throw new StationXMLException("Expected START_ELEMENT of type " + elementName);
    }

    public static int pullInt(XMLEventReader reader, String elementName) throws NumberFormatException, XMLStreamException, StationXMLException {
        return Integer.parseInt(StaxUtil.pullText(reader, elementName));
    }

    public static float pullFloat(XMLEventReader reader, String elementName) throws NumberFormatException, XMLStreamException, StationXMLException {
        return Float.parseFloat(StaxUtil.pullText(reader, elementName));
    }

    public static void skipToStartElement(XMLEventReader reader) throws XMLStreamException {
        if (!reader.hasNext()) {
            return;
        }
        while (reader.hasNext() && !reader.peek().isStartElement()) {
            reader.nextEvent();
        }
    }

    public static void skipToMatchingEnd(XMLEventReader reader) throws XMLStreamException {
        int count = 0;
        XMLEvent cur = reader.peek();
        if (cur.isStartElement() && reader.hasNext()) {
            ++count;
            reader.nextEvent();
        }
        while (count > 0 && reader.hasNext()) {
            cur = reader.peek();
            if (cur.isStartElement()) {
                ++count;
            } else if (cur.isEndElement()) {
                --count;
            }
            reader.nextEvent();
        }
    }

    public static void skipToStartOrEndElement(XMLEventReader reader) throws XMLStreamException {
        if (!reader.hasNext()) {
            return;
        }
        while (reader.hasNext() && !reader.peek().isStartElement() && !reader.peek().isEndElement()) {
            reader.nextEvent();
        }
    }

    public static boolean hasNext(XMLEventReader reader, String elementName, String endElementName) throws XMLStreamException {
        while (reader.hasNext()) {
            if (reader.peek().isStartElement()) {
                if (reader.peek().asStartElement().getName().getLocalPart().equals(elementName)) {
                    return true;
                }
                reader.next();
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (reader.peek().isEndElement() && reader.peek().asEndElement().getName().getLocalPart().equals(endElementName)) {
                return false;
            }
            reader.next();
        }
        return false;
    }

    public static String pullAttribute(StartElement start, String name) throws StationXMLException {
        Iterator<Attribute> it = start.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            if (!a.getName().getLocalPart().equals(name)) continue;
            return a.getValue();
        }
        throw new StationXMLException(name + " not found as an attribute");
    }

    public static Integer pullIntAttribute(StartElement start, String name) throws StationXMLException {
        return Integer.parseInt(StaxUtil.pullAttribute(start, name));
    }
}

