/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.Channel;
import edu.sc.seis.seisFile.stationxml.Epoch;
import edu.sc.seis.seisFile.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.stationxml.IrisComment;
import edu.sc.seis.seisFile.stationxml.Network;
import edu.sc.seis.seisFile.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.stationxml.Response;
import edu.sc.seis.seisFile.stationxml.StaMessage;
import edu.sc.seis.seisFile.stationxml.Station;
import edu.sc.seis.seisFile.stationxml.StationEpoch;
import edu.sc.seis.seisFile.stationxml.StationIterator;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class StationXMLClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws XMLStreamException, StationXMLException, IOException {
        HttpURLConnection conn;
        if (args.length != 2 || !args[0].equals("-u")) {
            System.out.println("Usage: stationxmlclient -u url");
            System.out.println("       stationxmlclient -u http://www.iris.edu/ws/station/query?net=IU&sta=SNZO&chan=BHZ&level=chan");
            return;
        }
        URL url = new URL(args[1]);
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection && (conn = (HttpURLConnection)urlConn).getResponseCode() != 200) {
            String out = "";
            BufferedReader errReader = null;
            try {
                String line;
                errReader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                while ((line = errReader.readLine()) != null) {
                    out = out + line + "\n";
                }
            }
            finally {
                if (errReader != null) {
                    errReader.close();
                    conn.disconnect();
                }
            }
            System.err.println("Error in connection with url: " + url);
            System.err.println(out);
            return;
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader r = factory.createXMLEventReader(url.toString(), urlConn.getInputStream());
        XMLEvent e = r.peek();
        while (!e.isStartElement()) {
            e = r.nextEvent();
            e = r.peek();
        }
        System.out.println("StaMessage");
        StaMessage staMessage = new StaMessage(r);
        if (!staMessage.checkSchemaVersion()) {
            System.out.println("");
            System.out.println("WARNING: XmlSchema of this document does not match this code, results may be incorrect.");
            System.out.println("XmlSchema (code): http://www.data.scec.org/xml/station/20120307/");
            System.out.println("");
        }
        System.out.println("XmlSchema: " + staMessage.getXmlSchemaLocation());
        System.out.println("Source: " + staMessage.getSource());
        System.out.println("Sender: " + staMessage.getSender());
        System.out.println("Module: " + staMessage.getModule());
        System.out.println("SentDate: " + staMessage.getSentDate());
        NetworkIterator it = staMessage.getNetworks();
        while (it.hasNext()) {
            Network n = it.next();
            System.out.println("Network: " + n.getNetCode() + " " + n.getDescription() + " " + n.getStartDate() + " " + n.getEndDate());
            StationIterator sit = n.getStations();
            while (sit.hasNext()) {
                Station s = sit.next();
                if (!n.getNetCode().equals(s.getNetCode())) {
                    throw new StationXMLException("Station in wrong network: " + n.getNetCode() + " != " + s.getNetCode() + "  " + r.peek().getLocation());
                }
                System.out.println("  Station: " + s.getNetCode() + "." + s.getStaCode() + " " + s.getStationEpochs().size());
                List<StationEpoch> staEpochs = s.getStationEpochs();
                for (StationEpoch stationEpoch : staEpochs) {
                    System.out.println("    Station Epoch: " + s.getNetCode() + "." + s.getStaCode() + "  " + stationEpoch.getStartDate() + " to " + stationEpoch.getEndDate());
                    for (IrisComment comment : stationEpoch.getIrisStationComments().getList()) {
                        System.out.println("          " + comment.getStartDate() + " " + comment.getEndDate() + " " + comment.getCommentClass() + " " + comment.getText());
                    }
                    List<Channel> chanList = stationEpoch.getChannelList();
                    for (Channel channel : chanList) {
                        List<Epoch> chanEpochList = channel.getChanEpochList();
                        for (Epoch epoch : chanEpochList) {
                            System.out.println("      Channel Epoch: " + channel.getLocCode() + "." + channel.getChanCode() + "  " + epoch.getStartDate() + " to " + epoch.getEndDate());
                            for (IrisComment comment : epoch.getIrisChannelComments().getList()) {
                                System.out.println("          " + comment.getStartDate() + " " + comment.getEndDate() + " " + comment.getCommentClass() + " " + comment.getText());
                            }
                            if (epoch.getResponseList().size() == 0) continue;
                            float overallGain = 1.0f;
                            for (Response resp : epoch.getResponseList()) {
                                System.out.print("          Resp " + resp.getStage());
                                if (resp.getResponseItem() != null) {
                                    System.out.print(" " + resp.getResponseItem().getInputUnits() + " " + resp.getResponseItem().getOutputUnits());
                                }
                                if (resp.getStageSensitivity() != null) {
                                    System.out.print(" " + resp.getStageSensitivity().getSensitivityValue());
                                    if (resp.getStage() != 0) {
                                        overallGain *= resp.getStageSensitivity().getSensitivityValue();
                                    }
                                }
                                System.out.println();
                            }
                            InstrumentSensitivity instSens = epoch.getInstrumentSensitivity();
                            System.out.println("          Overall Gain: " + overallGain + "  Inst Sense: " + instSens.getSensitivityValue() + " " + instSens.getSensitivityUnits());
                        }
                    }
                }
            }
        }
        staMessage.closeReader();
    }
}

