/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.Channel;
import edu.sc.seis.seisFile.stationxml.IrisCommentList;
import edu.sc.seis.seisFile.stationxml.Site;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StationEpoch {
    String startDate;
    String endDate;
    String creationDate;
    float lat;
    float lon;
    float elevation;
    String name;
    Site site;
    int totalNumChannels;
    int selectedNumChannels;
    List<Channel> channelList = new ArrayList<Channel>();
    IrisCommentList irisStationComments = new IrisCommentList("StationComments");

    public StationEpoch(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("StationEpoch", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("StartDate")) {
                    this.startDate = StaxUtil.pullText(reader, "StartDate");
                    continue;
                }
                if (elName.equals("EndDate")) {
                    this.endDate = StaxUtil.pullText(reader, "EndDate");
                    continue;
                }
                if (elName.equals("Lat")) {
                    this.lat = StaxUtil.pullFloat(reader, "Lat");
                    continue;
                }
                if (elName.equals("Lon")) {
                    this.lon = StaxUtil.pullFloat(reader, "Lon");
                    continue;
                }
                if (elName.equals("Elevation")) {
                    this.elevation = StaxUtil.pullFloat(reader, "Elevation");
                    continue;
                }
                if (elName.equals("Site")) {
                    this.site = new Site(reader);
                    continue;
                }
                if (elName.equals("Name")) {
                    this.name = StaxUtil.pullText(reader, "Name");
                    continue;
                }
                if (elName.equals("CreationDate")) {
                    this.creationDate = StaxUtil.pullText(reader, "CreationDate");
                    continue;
                }
                if (elName.equals("TotalNumberChannels")) {
                    this.totalNumChannels = StaxUtil.pullInt(reader, "TotalNumberChannels");
                    continue;
                }
                if (elName.equals("SelectedNumberChannels")) {
                    this.selectedNumChannels = StaxUtil.pullInt(reader, "SelectedNumberChannels");
                    continue;
                }
                if (elName.equals("StationComments")) {
                    this.irisStationComments = new IrisCommentList(reader, "StationComments");
                    continue;
                }
                if (elName.equals("Channel")) {
                    this.channelList.add(new Channel(reader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public float getLat() {
        return this.lat;
    }

    public float getLon() {
        return this.lon;
    }

    public float getElevation() {
        return this.elevation;
    }

    public String getName() {
        return this.name;
    }

    public Site getSite() {
        return this.site;
    }

    public int getTotalNumChannels() {
        return this.totalNumChannels;
    }

    public int getSelectedNumChannels() {
        return this.selectedNumChannels;
    }

    public List<Channel> getChannelList() {
        return this.channelList;
    }

    public IrisCommentList getIrisStationComments() {
        return this.irisStationComments;
    }
}

