/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationEpoch;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Station {
    List<StationEpoch> staList = new ArrayList<StationEpoch>();
    String netCode;
    String staCode;

    public Station(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Station", reader);
        this.netCode = StaxUtil.pullAttribute(startE, "net_code");
        this.staCode = StaxUtil.pullAttribute(startE, "sta_code");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("StationEpoch")) {
                    this.staList.add(new StationEpoch(reader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getNetCode() {
        return this.netCode;
    }

    public void setNetCode(String netCode) {
        this.netCode = netCode;
    }

    public String getStaCode() {
        return this.staCode;
    }

    public void setStaCode(String staCode) {
        this.staCode = staCode;
    }

    public List<StationEpoch> getStationEpochs() {
        return this.staList;
    }
}

