/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaMessage {
    XMLEventReader reader;
    String source;
    String sender;
    String module;
    String sentDate;
    String xmlSchemaLocation;
    NetworkIterator networks;
    private static final Logger logger = LoggerFactory.getLogger(StaMessage.class);

    public StaMessage(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        this.reader = reader;
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("StaMessage", reader);
        Attribute schemaLocAttr = startE.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        this.xmlSchemaLocation = schemaLocAttr.getValue();
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Source")) {
                    this.source = StaxUtil.pullText(reader, "Source");
                    continue;
                }
                if (elName.equals("Sender")) {
                    this.sender = StaxUtil.pullText(reader, "Sender");
                    continue;
                }
                if (elName.equals("Module")) {
                    this.module = StaxUtil.pullText(reader, "Module");
                    continue;
                }
                if (elName.equals("SentDate")) {
                    this.sentDate = StaxUtil.pullText(reader, "SentDate");
                    continue;
                }
                if (elName.equals("Network")) {
                    this.networks = new NetworkIterator(reader);
                    break;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                return;
            }
            e = reader.nextEvent();
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(String sentDate) {
        this.sentDate = sentDate;
    }

    public NetworkIterator getNetworks() {
        return this.networks;
    }

    public void closeReader() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            logger.warn("problem closing underlying XMLEventReader.", (Throwable)e);
        }
    }

    public String getXmlSchemaLocation() {
        return this.xmlSchemaLocation;
    }

    public void setXmlSchemaLocation(String xmlns) {
        this.xmlSchemaLocation = xmlns;
    }

    public boolean checkSchemaVersion() {
        return this.xmlSchemaLocation.split(" ")[0].equals("http://www.data.scec.org/xml/station/20120307/");
    }
}

