/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ResponseListElement {
    private float frequency;
    private float amplitude;
    private float phase;

    public ResponseListElement(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("PolesZeros", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Frequency")) {
                    this.frequency = StaxUtil.pullFloat(reader, "Frequency");
                    continue;
                }
                if (elName.equals("Amplitude")) {
                    this.amplitude = StaxUtil.pullFloat(reader, "Amplitude");
                    continue;
                }
                if (elName.equals("Phase")) {
                    this.phase = StaxUtil.pullFloat(reader, "Phase");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public float getFrequency() {
        return this.frequency;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public float getPhase() {
        return this.phase;
    }
}

