/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.ResponseListElement;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ResponseList
extends AbstractResponseType {
    private List<ResponseListElement> responseElements = new ArrayList<ResponseListElement>();

    public ResponseList(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("PolesZeros", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(reader, "InputUnits");
                    continue;
                }
                if (elName.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(reader, "OutputUnits");
                    continue;
                }
                if (elName.equals("ResponseListElement")) {
                    this.responseElements.add(new ResponseListElement(reader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public List<ResponseListElement> getResponseElements() {
        return this.responseElements;
    }
}

