/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.Coefficients;
import edu.sc.seis.seisFile.stationxml.Decimation;
import edu.sc.seis.seisFile.stationxml.FIR;
import edu.sc.seis.seisFile.stationxml.GainSensitivity;
import edu.sc.seis.seisFile.stationxml.Generic;
import edu.sc.seis.seisFile.stationxml.PolesZeros;
import edu.sc.seis.seisFile.stationxml.Polynomial;
import edu.sc.seis.seisFile.stationxml.ResponseList;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Response {
    private Integer stage;
    private String stageDescription;
    private AbstractResponseType responseItem;
    private Decimation decimation;
    private GainSensitivity stageSensitivity;

    public Response(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Response", reader);
        this.stage = StaxUtil.pullIntAttribute(startE, "stage");
        try {
            this.stageDescription = StaxUtil.pullAttribute(startE, "stage_description");
        }
        catch (StationXMLException e) {
            // empty catch block
        }
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("PolesZeros")) {
                    this.responseItem = new PolesZeros(reader);
                    continue;
                }
                if (elName.equals("Coefficients")) {
                    this.responseItem = new Coefficients(reader);
                    continue;
                }
                if (elName.equals("ResponseList")) {
                    this.responseItem = new ResponseList(reader);
                    continue;
                }
                if (elName.equals("Generic")) {
                    this.responseItem = new Generic(reader);
                    continue;
                }
                if (elName.equals("FIR")) {
                    this.responseItem = new FIR(reader);
                    continue;
                }
                if (elName.equals("Polynomial")) {
                    this.responseItem = new Polynomial(reader);
                    continue;
                }
                if (elName.equals("Decimation")) {
                    this.decimation = new Decimation(reader);
                    continue;
                }
                if (elName.equals("StageSensitivity")) {
                    this.stageSensitivity = new GainSensitivity(reader, "StageSensitivity");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public Integer getStage() {
        return this.stage;
    }

    public String getStageDescription() {
        return this.stageDescription;
    }

    public AbstractResponseType getResponseItem() {
        return this.responseItem;
    }

    public Decimation getDecimation() {
        return this.decimation;
    }

    public GainSensitivity getStageSensitivity() {
        return this.stageSensitivity;
    }
}

