/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Polynomial
extends AbstractResponseType {
    private String approximationType;
    private Float freqLowerBound;
    private float freqUpperBound;
    private float approxLowerBound;
    private float approxUpperBound;
    private float maxError;
    private List<Float> coefficientList = new ArrayList<Float>();

    public Polynomial(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("PolesZeros", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("ApproximationType")) {
                    this.approximationType = StaxUtil.pullText(reader, "ApproximationType");
                    continue;
                }
                if (elName.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(reader, "InputUnits");
                    continue;
                }
                if (elName.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(reader, "OutputUnits");
                    continue;
                }
                if (elName.equals("FreqLowerBound")) {
                    this.freqLowerBound = Float.valueOf(StaxUtil.pullFloat(reader, "FreqLowerBound"));
                    continue;
                }
                if (elName.equals("FreqUpperBound")) {
                    this.freqUpperBound = StaxUtil.pullFloat(reader, "FreqUpperBound");
                    continue;
                }
                if (elName.equals("ApproxLowerBound")) {
                    this.approxLowerBound = StaxUtil.pullFloat(reader, "ApproxLowerBound");
                    continue;
                }
                if (elName.equals("ApproxUpperBound")) {
                    this.approxUpperBound = StaxUtil.pullFloat(reader, "ApproxUpperBound");
                    continue;
                }
                if (elName.equals("MaxError")) {
                    this.maxError = StaxUtil.pullFloat(reader, "MaxError");
                    continue;
                }
                if (elName.equals("Coefficient")) {
                    this.coefficientList.add(Float.valueOf(StaxUtil.pullFloat(reader, "Coefficient")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getApproximationType() {
        return this.approximationType;
    }

    public Float getFreqLowerBound() {
        return this.freqLowerBound;
    }

    public float getFreqUpperBound() {
        return this.freqUpperBound;
    }

    public float getApproxLowerBound() {
        return this.approxLowerBound;
    }

    public float getApproxUpperBound() {
        return this.approxUpperBound;
    }

    public float getMaxError() {
        return this.maxError;
    }

    public List<Float> getCoefficientList() {
        return this.coefficientList;
    }
}

