/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.ListStationIterator;
import edu.sc.seis.seisFile.stationxml.Station;
import edu.sc.seis.seisFile.stationxml.StationIterator;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Network {
    String netCode;
    String startDate;
    String endDate;
    String description;
    int totalNumStations;
    int selectedNumStations;
    StationIterator stations = new ListStationIterator(new ArrayList<Station>());

    public Network(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Network", reader);
        this.netCode = StaxUtil.pullAttribute(startE, "net_code");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("StartDate")) {
                    this.startDate = StaxUtil.pullText(reader, "StartDate");
                    continue;
                }
                if (elName.equals("EndDate")) {
                    this.endDate = StaxUtil.pullText(reader, "EndDate");
                    continue;
                }
                if (elName.equals("Description")) {
                    this.description = StaxUtil.pullText(reader, "Description");
                    continue;
                }
                if (elName.equals("TotalNumberStations")) {
                    this.totalNumStations = StaxUtil.pullInt(reader, "TotalNumberStations");
                    continue;
                }
                if (elName.equals("SelectedNumberStations")) {
                    this.selectedNumStations = StaxUtil.pullInt(reader, "SelectedNumberStations");
                    continue;
                }
                if (elName.equals("Station")) {
                    this.stations = new StationIterator(reader);
                    break;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getNetCode() {
        return this.netCode;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getDescription() {
        return this.description;
    }

    public StationIterator getStations() {
        return this.stations;
    }

    public int getTotalNumStations() {
        return this.totalNumStations;
    }

    public int getSelectedNumStations() {
        return this.selectedNumStations;
    }
}

