/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.IrisComment;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class IrisCommentList {
    private String elementName;
    private List<IrisComment> list = new ArrayList<IrisComment>();

    public IrisCommentList(String elementName) {
        this.elementName = elementName;
    }

    public IrisCommentList(XMLEventReader reader, String elementName) throws XMLStreamException, StationXMLException {
        this(elementName);
        StartElement startE = StaxUtil.expectStartElement(elementName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Comment")) {
                    this.list.add(new IrisComment(reader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    public List<IrisComment> getList() {
        return this.list;
    }
}

