/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class InstrumentSensitivity {
    float sensitivityValue;
    float frequency;
    String sensitivityUnits;

    public InstrumentSensitivity(float value, String unit, float frequency) {
        this.sensitivityValue = value;
        this.sensitivityUnits = unit;
        this.frequency = frequency;
    }

    public InstrumentSensitivity(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("InstrumentSensitivity", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("SensitivityValue")) {
                    this.sensitivityValue = StaxUtil.pullFloat(reader, "SensitivityValue");
                    continue;
                }
                if (elName.equals("Frequency")) {
                    this.frequency = StaxUtil.pullFloat(reader, "Frequency");
                    continue;
                }
                if (elName.equals("SensitivityUnits")) {
                    this.sensitivityUnits = StaxUtil.pullText(reader, "SensitivityUnits");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public float getSensitivityValue() {
        return this.sensitivityValue;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public String getSensitivityUnits() {
        return this.sensitivityUnits;
    }
}

