/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class FIR
extends AbstractResponseType {
    String responseName;
    String symmetry;
    List<Float> numeratorCoefficientList = new ArrayList<Float>();

    public FIR(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("PolesZeros", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("ResponseName")) {
                    this.responseName = StaxUtil.pullText(reader, "ResponseName");
                    continue;
                }
                if (elName.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(reader, "InputUnits");
                    continue;
                }
                if (elName.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(reader, "OutputUnits");
                    continue;
                }
                if (elName.equals("Symmetry")) {
                    this.symmetry = StaxUtil.pullText(reader, "Symmetry");
                    continue;
                }
                if (elName.equals("NumeratorCoefficient")) {
                    this.numeratorCoefficientList.add(Float.valueOf(StaxUtil.pullFloat(reader, "NormalizationFactor")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getResponseName() {
        return this.responseName;
    }

    public String getSymmetry() {
        return this.symmetry;
    }

    public List<Float> getNumeratorCoefficientList() {
        return this.numeratorCoefficientList;
    }
}

