/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.DataLogger;
import edu.sc.seis.seisFile.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.stationxml.IrisCommentList;
import edu.sc.seis.seisFile.stationxml.Response;
import edu.sc.seis.seisFile.stationxml.Sensor;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Epoch {
    String startDate;
    String endDate;
    String creationDate;
    float lat;
    float lon;
    float elevation;
    float depth;
    float azimuth;
    float dip;
    float sampleRate;
    float clockDrift;
    DataLogger dataLogger;
    Sensor sensor;
    InstrumentSensitivity instrumentSensitivity;
    List<Response> responseList = new ArrayList<Response>();
    IrisCommentList irisChannelComments = new IrisCommentList("ChannelComments");

    public Epoch(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Epoch", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("StartDate")) {
                    this.startDate = StaxUtil.pullText(reader, "StartDate");
                    continue;
                }
                if (elName.equals("EndDate")) {
                    this.endDate = StaxUtil.pullText(reader, "EndDate");
                    continue;
                }
                if (elName.equals("Lat")) {
                    this.lat = StaxUtil.pullFloat(reader, "Lat");
                    continue;
                }
                if (elName.equals("Lon")) {
                    this.lon = StaxUtil.pullFloat(reader, "Lon");
                    continue;
                }
                if (elName.equals("Elevation")) {
                    this.elevation = StaxUtil.pullFloat(reader, "Elevation");
                    continue;
                }
                if (elName.equals("Depth")) {
                    this.depth = StaxUtil.pullFloat(reader, "Depth");
                    continue;
                }
                if (elName.equals("Azimuth")) {
                    this.azimuth = StaxUtil.pullFloat(reader, "Azimuth");
                    continue;
                }
                if (elName.equals("Dip")) {
                    this.dip = StaxUtil.pullFloat(reader, "Dip");
                    continue;
                }
                if (elName.equals("SampleRate")) {
                    this.sampleRate = StaxUtil.pullFloat(reader, "SampleRate");
                    continue;
                }
                if (elName.equals("ClockDrift")) {
                    this.clockDrift = StaxUtil.pullFloat(reader, "ClockDrift");
                    continue;
                }
                if (elName.equals("DataLogger")) {
                    this.dataLogger = new DataLogger(reader);
                    continue;
                }
                if (elName.equals("Sensor")) {
                    this.sensor = new Sensor(reader);
                    continue;
                }
                if (elName.equals("InstrumentSensitivity")) {
                    this.instrumentSensitivity = new InstrumentSensitivity(reader);
                    continue;
                }
                if (elName.equals("Response")) {
                    this.responseList.add(new Response(reader));
                    continue;
                }
                if (elName.equals("ChannelComments")) {
                    this.irisChannelComments = new IrisCommentList(reader, "ChannelComments");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public float getLat() {
        return this.lat;
    }

    public float getLon() {
        return this.lon;
    }

    public float getElevation() {
        return this.elevation;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public float getDip() {
        return this.dip;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public float getClockDrift() {
        return this.clockDrift;
    }

    public DataLogger getDataLogger() {
        return this.dataLogger;
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public InstrumentSensitivity getInstrumentSensitivity() {
        return this.instrumentSensitivity;
    }

    public List<Response> getResponseList() {
        return this.responseList;
    }

    public IrisCommentList getIrisChannelComments() {
        return this.irisChannelComments;
    }
}

