/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Decimation {
    private float inputSampleRate;
    private int factor;
    private int offset;
    private float delay;
    private float correction;

    public Decimation(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Decimation", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("InputSampleRate")) {
                    this.inputSampleRate = StaxUtil.pullFloat(reader, "InputSampleRate");
                    continue;
                }
                if (elName.equals("Factor")) {
                    this.factor = StaxUtil.pullInt(reader, "Factor");
                    continue;
                }
                if (elName.equals("Offset")) {
                    this.offset = StaxUtil.pullInt(reader, "Offset");
                    continue;
                }
                if (elName.equals("Delay")) {
                    this.delay = StaxUtil.pullFloat(reader, "Delay");
                    continue;
                }
                if (elName.equals("Correction")) {
                    this.correction = StaxUtil.pullFloat(reader, "Correction");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public float getInputSampleRate() {
        return this.inputSampleRate;
    }

    public int getFactor() {
        return this.factor;
    }

    public int getOffset() {
        return this.offset;
    }

    public float getDelay() {
        return this.delay;
    }

    public float getCorrection() {
        return this.correction;
    }
}

