/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.Equipment;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataLogger
extends Equipment {
    protected int totalChannels;
    protected int recordedChannels;

    public DataLogger(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("DataLogger", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("EquipType")) {
                    this.equipType = StaxUtil.pullText(reader, "EquipType");
                    continue;
                }
                if (elName.equals("Description")) {
                    this.description = StaxUtil.pullText(reader, "Description");
                    continue;
                }
                if (elName.equals("Manufacturer")) {
                    this.manufacturer = StaxUtil.pullText(reader, "Manufacturer");
                    continue;
                }
                if (elName.equals("Vendor")) {
                    this.vendor = StaxUtil.pullText(reader, "Vendor");
                    continue;
                }
                if (elName.equals("Model")) {
                    this.model = StaxUtil.pullText(reader, "Model");
                    continue;
                }
                if (elName.equals("SerialNumber")) {
                    this.serialNumber = StaxUtil.pullText(reader, "SerialNumber");
                    continue;
                }
                if (elName.equals("InstallationDate")) {
                    this.installationDate = StaxUtil.pullText(reader, "InstallationDate");
                    continue;
                }
                if (elName.equals("RemovalDate")) {
                    this.removalDate = StaxUtil.pullText(reader, "RemovalDate");
                    continue;
                }
                if (elName.equals("CalibrationDate")) {
                    this.calibrationDate.add(StaxUtil.pullText(reader, "CalibrationDate"));
                    continue;
                }
                if (elName.equals("TotalChannels")) {
                    this.totalChannels = StaxUtil.pullInt(reader, "TotalChannels");
                    continue;
                }
                if (elName.equals("RecordedChannels")) {
                    this.recordedChannels = StaxUtil.pullInt(reader, "RecordedChannels");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public int getTotalChannels() {
        return this.totalChannels;
    }

    public int getRecordedChannels() {
        return this.recordedChannels;
    }
}

