/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Coefficients
extends AbstractResponseType {
    private static String cfTransferType;
    List<Float> numeratorList = new ArrayList<Float>();
    List<Float> denominatorList = new ArrayList<Float>();

    public Coefficients(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Coefficients", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(reader, "InputUnits");
                    continue;
                }
                if (elName.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(reader, "OutputUnits");
                    continue;
                }
                if (elName.equals("CfTransferFunctionType")) {
                    cfTransferType = StaxUtil.pullText(reader, "CfTransferFunctionType");
                    continue;
                }
                if (elName.equals("Numerator")) {
                    this.numeratorList.add(Float.valueOf(StaxUtil.pullFloat(reader, "Numerator")));
                    continue;
                }
                if (elName.equals("Demoninator")) {
                    this.denominatorList.add(Float.valueOf(StaxUtil.pullFloat(reader, "Demoninator")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public static String getCfTransferType() {
        return cfTransferType;
    }

    public List<Float> getNumeratorList() {
        return this.numeratorList;
    }

    public List<Float> getDenominatorList() {
        return this.denominatorList;
    }
}

