/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.Epoch;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Channel {
    List<Epoch> chanEpochList = new ArrayList<Epoch>();
    String chanCode;
    String locCode;
    String creationDate;

    public Channel(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Channel", reader);
        this.locCode = StaxUtil.pullAttribute(startE, "loc_code");
        this.chanCode = StaxUtil.pullAttribute(startE, "chan_code");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Epoch")) {
                    this.chanEpochList.add(new Epoch(reader));
                    continue;
                }
                if (elName.equals("CreationDate")) {
                    this.creationDate = StaxUtil.pullText(reader, "CreationDate");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public List<Epoch> getChanEpochList() {
        return this.chanEpochList;
    }

    public String getChanCode() {
        return this.chanCode;
    }

    public String getLocCode() {
        return this.locCode;
    }

    public String getCreationDate() {
        return this.creationDate;
    }
}

