/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.seedlink;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.seedlink.SeedlinkException;
import edu.sc.seis.seisFile.seedlink.SeedlinkPacket;
import edu.sc.seis.seisFile.seedlink.SeedlinkReader;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.Date;

public class Client {
    public static void printHelp(PrintWriter out) {
        out.println("java " + Client.class.getName() + " [-n net][-s sta][-l loc][-c chan][-h host][-p port][-o outfile][-m maxpackets][--timeout seconds][--verbose][--version][--help]");
    }

    public static void main(String[] args) throws UnknownHostException, IOException, SeedlinkException, SeedFormatException {
        String network = "TA";
        String station = "*";
        String location = "";
        String channel = "BHZ";
        String outFile = null;
        String host = "rtserve.iris.washington.edu";
        int port = 18000;
        int maxRecords = 10;
        int timeoutSeconds = 120;
        String infoType = "";
        boolean verbose = false;
        FilterOutputStream dos = null;
        PrintWriter out = new PrintWriter(System.out, true);
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].equals("-n")) {
                    network = args[i + 1];
                    continue;
                }
                if (args[i].equals("-s")) {
                    station = args[i + 1];
                    continue;
                }
                if (args[i].equals("-l")) {
                    location = args[i + 1];
                    continue;
                }
                if (args[i].equals("-c")) {
                    channel = args[i + 1];
                    continue;
                }
                if (args[i].equals("-i")) {
                    infoType = args[i + 1];
                    continue;
                }
                if (args[i].equals("-h")) {
                    host = args[i + 1];
                    continue;
                }
                if (args[i].equals("-p")) {
                    port = Integer.parseInt(args[i + 1]);
                    continue;
                }
                if (args[i].equals("-o")) {
                    outFile = args[i + 1];
                    dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
                    continue;
                }
                if (args[i].equals("-m")) {
                    maxRecords = Integer.parseInt(args[i + 1]);
                    if (maxRecords >= -1) continue;
                    maxRecords = -1;
                    continue;
                }
                if (args[i].equals("--timeout")) {
                    timeoutSeconds = Integer.parseInt(args[i + 1]);
                    continue;
                }
                if (args[i].equals("--verbose")) {
                    verbose = true;
                    continue;
                }
                if (args[i].equals("--version")) {
                    out.println(BuildVersion.getDetailedVersion());
                    System.exit(0);
                    continue;
                }
                if (!args[i].equals("--help")) continue;
                Client.printHelp(out);
                System.exit(0);
                continue;
            }
            catch (Throwable ex) {
                out.println("Bad argument " + args[i]);
                Client.printHelp(out);
                System.exit(1);
            }
        }
        SeedlinkReader reader = new SeedlinkReader(host, port, timeoutSeconds, verbose);
        if (verbose) {
            reader.setVerboseWriter(out);
            String[] lines = reader.sendHello();
            out.println("line 1 :" + lines[0]);
            out.println("line 2 :" + lines[1]);
            out.flush();
        }
        if (infoType != null && infoType.length() != 0) {
            SeedlinkPacket infoPacket;
            reader.info(infoType);
            do {
                infoPacket = reader.next();
                infoPacket.getMiniSeed().writeASCII(out, "    ");
                out.println("    " + new String(infoPacket.getMiniSeed().getData()));
            } while (infoPacket.isInfoContinuesPacket());
        }
        reader.sendCmd("STATION " + station + " " + network);
        reader.sendCmd("SELECT " + location + channel + ".D");
        reader.sendCmd("DATA");
        reader.endHandshake();
        try {
            for (int i = 0; (maxRecords == -1 || i < maxRecords) && reader.isConnected(); ++i) {
                SeedlinkPacket slp = reader.next();
                DataRecord dr = slp.getMiniSeed();
                if (dos != null) {
                    dr.write((DataOutputStream)dos);
                }
                if (dos != null && !verbose) continue;
                dr.writeASCII(out, "    ");
                out.flush();
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        if (dos != null) {
            dos.close();
        }
        reader.close();
        out.println("Finished: " + new Date());
    }
}

