/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.ControlRecordLengthBlockette;
import edu.sc.seis.seisFile.mseed.PartialBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.DataInput;
import java.io.IOException;

public class ControlRecord
extends SeedRecord {
    public static final String THREESPACE = "   ";

    public ControlRecord(ControlHeader header) {
        super(header);
    }

    public static ControlRecord readControlRecord(DataInput inStream, ControlHeader header, int defaultRecordSize, SeedRecord priorRecord) throws IOException, SeedFormatException {
        String typeStr;
        byte[] readBytes;
        PartialBlockette pb;
        int recordSize = defaultRecordSize;
        ControlRecord controlRec = new ControlRecord(header);
        int currOffset = header.getSize();
        if (priorRecord != null && header.isContinuation() && (pb = priorRecord.getLastPartialBlockette()) != null) {
            int length = pb.getTotalSize() - pb.getSoFarSize();
            readBytes = length + currOffset < recordSize ? new byte[length] : new byte[recordSize - currOffset];
            inStream.readFully(readBytes);
            currOffset += readBytes.length;
            PartialBlockette b = new PartialBlockette(pb.getType(), readBytes, pb.getSwapBytes(), pb.getSoFarSize(), pb.getTotalSize());
            if (b instanceof ControlRecordLengthBlockette) {
                recordSize = ((ControlRecordLengthBlockette)((Object)b)).getLogicalRecordLength();
            }
            controlRec.addBlockette(b);
            if (defaultRecordSize != 0 && currOffset > recordSize - 7) {
                controlRec.RECORD_SIZE = recordSize;
                byte[] garbage = new byte[recordSize - currOffset];
                if (garbage.length != 0) {
                    inStream.readFully(garbage);
                }
                return controlRec;
            }
        }
        byte[] typeBytes = new byte[3];
        if (defaultRecordSize == 0 || currOffset < recordSize - 3) {
            inStream.readFully(typeBytes);
            typeStr = new String(typeBytes);
            currOffset += typeBytes.length;
        } else {
            typeStr = THREESPACE;
        }
        while (!(typeStr.equals(THREESPACE) || defaultRecordSize != 0 && currOffset > recordSize - 7)) {
            int type = Integer.parseInt(typeStr.trim());
            byte[] lengthBytes = new byte[4];
            inStream.readFully(lengthBytes);
            String lengthStr = new String(lengthBytes);
            int length = Integer.parseInt(lengthStr.trim());
            readBytes = length + (currOffset += lengthBytes.length) - 7 < recordSize ? new byte[length - 7] : new byte[recordSize - currOffset];
            inStream.readFully(readBytes);
            currOffset += readBytes.length;
            byte[] fullBlocketteBytes = new byte[7 + readBytes.length];
            System.arraycopy(typeBytes, 0, fullBlocketteBytes, 0, 3);
            System.arraycopy(lengthBytes, 0, fullBlocketteBytes, 3, 4);
            System.arraycopy(readBytes, 0, fullBlocketteBytes, 7, readBytes.length);
            Blockette b = length == fullBlocketteBytes.length ? SeedRecord.getBlocketteFactory().parseBlockette(type, fullBlocketteBytes, true) : new PartialBlockette(type, fullBlocketteBytes, true, 0, length);
            if (b instanceof ControlRecordLengthBlockette) {
                recordSize = ((ControlRecordLengthBlockette)b).getLogicalRecordLength();
            }
            controlRec.addBlockette(b);
            if (defaultRecordSize == 0 || currOffset < recordSize - 3) {
                inStream.readFully(typeBytes);
                typeStr = new String(typeBytes);
                currOffset += typeBytes.length;
                continue;
            }
            typeStr = THREESPACE;
        }
        if (recordSize == 0 && defaultRecordSize == 0) {
            throw new SeedFormatException("No blockettes 5, 8 or 10 to indicated record size and no default set");
        }
        controlRec.RECORD_SIZE = recordSize = defaultRecordSize;
        byte[] garbage = new byte[recordSize - currOffset];
        if (garbage.length != 0) {
            inStream.readFully(garbage);
        }
        return controlRec;
    }

    public void setRecordSize(int recordSize) throws SeedFormatException {
        this.RECORD_SIZE = recordSize;
    }
}

