/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.IOException;
import java.io.PrintWriter;

public class Blockette1001
extends DataBlockette {
    public static final int B1001_SIZE = 8;

    public Blockette1001() {
        super(8);
    }

    public Blockette1001(byte[] info, boolean swapBytes) throws SeedFormatException {
        super(info, swapBytes);
        this.trimToSize(8);
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public int getType() {
        return 1001;
    }

    @Override
    public String getName() {
        return "Data Extension Blockette";
    }

    public byte getTimingQuality() {
        return this.info[4];
    }

    public void setTimingQuality(byte v) {
        this.info[4] = v;
    }

    public byte getMicrosecond() {
        return this.info[5];
    }

    public void setMicrosecond(byte v) {
        this.info[5] = v;
    }

    public byte getReserved() {
        return this.info[6];
    }

    public void setReserved(byte v) {
        this.info[6] = v;
    }

    public byte getFrameCount() {
        return this.info[7];
    }

    public void setFrameCount(byte v) {
        this.info[7] = v;
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.println("Blockette1001 tQual=" + this.getTimingQuality() + " microsec=" + this.getMicrosecond() + " frameC=" + this.getFrameCount());
    }
}

