/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.dataSelectWS;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.StringMSeedQueryReader;
import edu.sc.seis.seisFile.dataSelectWS.DataSelectException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSelectReader
extends StringMSeedQueryReader {
    protected int timeoutMillis;
    protected String urlBase;
    protected String userAgent = "SeisFile/" + BuildVersion.getVersion();
    public static final String DEFAULT_WS_URL = "http://www.iris.edu/ws/dataselect/query";
    private static final Logger logger = LoggerFactory.getLogger(DataSelectReader.class);

    public DataSelectReader() {
        this(DEFAULT_WS_URL);
    }

    public DataSelectReader(String urlBase) {
        this.urlBase = urlBase;
    }

    public DataSelectReader(String urlBase, int timeoutMillis) {
        this.urlBase = urlBase;
        this.timeoutMillis = timeoutMillis;
    }

    protected String createQuery(String network, String station, String location, String channel) throws IOException, DataSelectException, SeedFormatException {
        String query = "net=" + network;
        query = query + "&sta=" + station;
        query = query + "&loc=" + location;
        query = query + "&cha=" + channel;
        return query;
    }

    @Override
    public String createQuery(String network, String station, String location, String channel, Date begin, Date end) throws IOException, DataSelectException, SeedFormatException {
        String query = this.createQuery(network, station, location, channel);
        SimpleDateFormat longFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        longFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        query = query + "&start=" + longFormat.format(begin);
        query = query + "&end=" + longFormat.format(end);
        return query;
    }

    @Override
    public List<DataRecord> read(String query) throws IOException, DataSelectException, SeedFormatException {
        URL requestURL = new URL(this.urlBase + "?" + query);
        HttpURLConnection conn = (HttpURLConnection)requestURL.openConnection();
        if (this.timeoutMillis != 0) {
            conn.setReadTimeout(this.timeoutMillis);
        }
        conn.setRequestProperty("User-Agent", this.userAgent);
        conn.connect();
        if (conn.getResponseCode() != 200) {
            if (conn.getResponseCode() == 404) {
                logger.debug("reponseCode 404, no data");
                return new ArrayList<DataRecord>();
            }
            throw new DataSelectException("Did not get an OK repsonse code, code= :" + conn.getResponseCode());
        }
        BufferedInputStream bif = new BufferedInputStream(conn.getInputStream());
        DataInputStream in = new DataInputStream(bif);
        ArrayList<DataRecord> records = new ArrayList<DataRecord>();
        try {
            while (true) {
                SeedRecord sr;
                if ((sr = SeedRecord.read(in)) instanceof DataRecord) {
                    records.add((DataRecord)sr);
                    continue;
                }
                logger.warn("Not a data record, skipping..." + sr.getControlHeader().getSequenceNum() + " " + sr.getControlHeader().getTypeCode());
            }
        }
        catch (EOFException e) {
            in.close();
            return records;
        }
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUrlBase() {
        return this.urlBase;
    }
}

