/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.SeisFileException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class QueryParams {
    String network;
    String station;
    String location;
    String channel;
    Date begin;
    Date end;
    Float duration = Float.valueOf(600.0f);
    int maxRecords = -1;
    String outFile = null;
    boolean verbose = false;
    boolean printVersion = false;
    boolean printHelp = false;
    DataOutputStream dos = null;
    boolean append = false;

    public QueryParams(String[] args) throws SeisFileException {
        PrintWriter out = new PrintWriter(System.out, true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-n")) {
                this.network = args[i + 1];
                continue;
            }
            if (args[i].equals("-s")) {
                this.station = args[i + 1];
                continue;
            }
            if (args[i].equals("-l")) {
                this.location = args[i + 1];
                continue;
            }
            if (args[i].equals("-c")) {
                this.channel = args[i + 1];
                continue;
            }
            if (args[i].equals("-b")) {
                this.begin = this.extractDate(args[i + 1]);
                continue;
            }
            if (args[i].equals("-e")) {
                this.end = this.extractDate(args[i + 1]);
                continue;
            }
            if (args[i].equals("-d")) {
                this.duration = Float.valueOf(Float.parseFloat(args[i + 1]));
                continue;
            }
            if (args[i].equals("-o")) {
                this.outFile = args[i + 1];
                continue;
            }
            if (args[i].equals("-m")) {
                this.maxRecords = Integer.parseInt(args[i + 1]);
                if (this.maxRecords >= -1) continue;
                this.maxRecords = -1;
                continue;
            }
            if (args[i].equals("--append")) {
                this.append = true;
                continue;
            }
            if (args[i].equals("--verbose")) {
                this.verbose = true;
                continue;
            }
            if (args[i].equals("--version")) {
                this.printVersion = true;
                continue;
            }
            if (!args[i].equals("--help")) continue;
            this.printHelp = true;
        }
        if (args.length == 0) {
            this.printHelp = true;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.add(13, -1 * Math.round(this.duration.floatValue()));
        cal.add(14, -1000 * Math.round(this.duration.floatValue() - (float)Math.round(this.duration.floatValue())));
        if (this.begin == null) {
            this.begin = cal.getTime();
        }
        if (this.end == null) {
            cal.setTime(this.begin);
            cal.add(13, Math.round(this.duration.floatValue()));
            cal.add(14, 1000 * Math.round(this.duration.floatValue() - (float)Math.round(this.duration.floatValue())));
            this.end = cal.getTime();
        }
    }

    public String getNetwork() {
        return this.network;
    }

    public String getStation() {
        return this.station;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannel() {
        return this.channel;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Float getDuration() {
        return this.duration;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public static String getStandardHelpOptions() {
        return "[-n net][-s sta][-l loc][-c chan][-b yyyy-MM-dd[THH:mm:ss.SSS]][-e yyyy-MM-dd[THH:mm:ss.SSS]][-d seconds][-o outfile][-m maxpackets][--append][--verbose][--version][--help]";
    }

    public DataOutputStream getDataOutputStream() throws FileNotFoundException {
        if (this.dos == null) {
            this.dos = this.getOutFile() == null ? new DataOutputStream(System.out) : new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile, this.isAppend())));
        }
        return this.dos;
    }

    Date extractDate(String dateString) throws SeisFileException {
        SimpleDateFormat dateFormat = (dateString = dateString.trim()).length() == 23 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz") : (dateString.length() == 19 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz") : new SimpleDateFormat("yyyy-MM-dd"));
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (dateString.length() > 10 && dateString.matches(".+\\d")) {
            dateString = dateString + " GMT";
        }
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new SeisFileException("Illegal date format, should be: yyyy-MM-dd or yyyy-MM-dd'T'HH:mm:ss or yyyy-MM-dd'T'HH:mm:ss.SSS", e);
        }
    }
}

