/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.MSeedQueryReader;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class MSeedQueryClient {
    protected QueryParams params;
    protected MSeedQueryReader reader;

    public MSeedQueryClient(String[] args) throws SeisFileException {
        BasicConfigurator.configure();
        this.params = new QueryParams(args);
        Logger.getRootLogger().setLevel(Level.WARN);
        if (this.params.isVerbose()) {
            Logger.getLogger((String)"root").setLevel(Level.DEBUG);
        }
        if (this.params.isPrintHelp()) {
            System.out.println(this.getHelp());
            System.exit(0);
        } else if (this.params.isPrintVersion()) {
            System.out.println("Version: " + BuildVersion.getDetailedVersion());
            System.exit(0);
        }
    }

    public void readData(String[] args) throws SeisFileException, IOException {
        String network = "IU";
        String station = "ANMO";
        String location = "00";
        String channel = "BHZ";
        String outFile = null;
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.add(12, -10);
        Date begin = cal.getTime();
        Float duration = Float.valueOf(600.0f);
        int maxRecords = 10;
        boolean verbose = false;
        DataOutputStream dos = null;
        PrintWriter out = new PrintWriter(System.out, true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-n")) {
                network = args[i + 1];
                continue;
            }
            if (args[i].equals("-s")) {
                station = args[i + 1];
                continue;
            }
            if (args[i].equals("-l")) {
                location = args[i + 1];
                continue;
            }
            if (args[i].equals("-c")) {
                channel = args[i + 1];
                continue;
            }
            if (args[i].equals("-b")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                String beginStr = args[i + 1].trim();
                if (beginStr.matches(".+\\d")) {
                    beginStr = beginStr + " GMT";
                }
                try {
                    begin = dateFormat.parse(beginStr);
                    continue;
                }
                catch (ParseException e) {
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
                    try {
                        begin = dateFormat.parse(beginStr);
                        continue;
                    }
                    catch (ParseException ee) {
                        throw new SeisFileException("Illegal date format, should be:  yyyy-MM-dd'T'HH:mm:ss or yyyy-MM-dd'T'HH:mm:ss.SSS", ee);
                    }
                }
            }
            if (args[i].equals("-d")) {
                duration = Float.valueOf(Float.parseFloat(args[i + 1]));
                continue;
            }
            if (args[i].equals("-o")) {
                outFile = args[i + 1];
                dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
                continue;
            }
            if (args[i].equals("-m")) {
                maxRecords = Integer.parseInt(args[i + 1]);
                if (maxRecords >= -1) continue;
                maxRecords = -1;
                continue;
            }
            if (args[i].equals("--verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("--version")) {
                out.println(BuildVersion.getDetailedVersion());
                System.exit(0);
                continue;
            }
            if (!args[i].equals("--help")) continue;
            out.println(this.getHelp());
            System.exit(0);
        }
    }

    public void readData() throws SeedFormatException, IOException, SeisFileException {
        if (this.params.isVerbose()) {
            this.reader.setVerbose(this.params.isVerbose());
        }
        PrintWriter out = new PrintWriter(System.out, true);
        List<DataRecord> data = this.reader.read(this.params.getNetwork(), this.params.getStation(), this.params.getLocation(), this.params.getChannel(), this.params.getBegin(), this.params.getEnd());
        for (DataRecord dr : data) {
            if (this.params.getDataOutputStream() != null) {
                dr.write(this.params.getDataOutputStream());
            }
            if (this.params.getDataOutputStream() != null && !this.params.isVerbose()) continue;
            dr.writeASCII(out, "    ");
            out.flush();
        }
        if (this.params.isVerbose() && data.size() == 0) {
            out.println("No Data.");
            out.flush();
        }
        if (this.params.getDataOutputStream() != null) {
            this.params.getDataOutputStream().flush();
        }
        if (this.params.isVerbose()) {
            out.println("Finished: " + new Date());
        }
    }

    public abstract String getHelp();
}

