/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.DexFile;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bridj.BridJ;
import org.bridj.ClassDefiner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AndroidClassDefiner
implements ClassDefiner {
    protected final File cacheDir;
    protected final ClassLoader parentClassLoader;

    public AndroidClassDefiner(File cacheDir, ClassLoader parentClassLoader) throws IOException {
        this.cacheDir = cacheDir;
        this.parentClassLoader = parentClassLoader;
    }

    static void delete(File f) {
        File[] fs = f.listFiles();
        if (fs != null) {
            for (File ff : fs) {
                AndroidClassDefiner.delete(ff);
            }
        }
        f.delete();
    }

    private static final byte[] dex(String className, byte[] classData) throws ClassFormatError {
        try {
            DexOptions dexOptions = new DexOptions();
            DexFile dxFile = new DexFile(dexOptions);
            CfOptions cfOptions = new CfOptions();
            dxFile.add(CfTranslator.translate((String)(className.replace('.', '/') + ".class"), (byte[])classData, (CfOptions)cfOptions, (DexOptions)dexOptions));
            StringWriter out = BridJ.debug ? new StringWriter() : null;
            byte[] dexData = dxFile.toDex((Writer)out, false);
            if (BridJ.debug) {
                BridJ.log(Level.INFO, "Dex output for class " + className + " : " + out);
            }
            return dexData;
        }
        catch (IOException ex) {
            throw new ClassFormatError("Unable to convert class data to Dalvik code using Dex : " + ex);
        }
    }

    @Override
    public Class<?> defineClass(String className, byte[] classData) throws ClassFormatError {
        Class clazz;
        File tempDir;
        block7: {
            byte[] dexData = AndroidClassDefiner.dex(className, classData);
            tempDir = null;
            File apkFile = null;
            try {
                tempDir = File.createTempFile("bridj.", ".tmp", this.cacheDir).getAbsoluteFile();
                tempDir.delete();
                tempDir.mkdir();
                apkFile = File.createTempFile("dynamic.", ".apk", tempDir).getAbsoluteFile();
                apkFile.getParentFile().mkdirs();
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(apkFile));
                out.putNextEntry(new ZipEntry("classes.dex"));
                out.write(dexData);
                out.closeEntry();
                out.close();
                DexClassLoader classLoader = new DexClassLoader(apkFile.toString(), tempDir.toString(), null, this.parentClassLoader);
                clazz = classLoader.loadClass(className);
                if (apkFile == null) break block7;
            }
            catch (Throwable th) {
                try {
                    throw new RuntimeException("Failed with tempFile = " + apkFile + " : " + th, th);
                }
                catch (Throwable throwable) {
                    if (apkFile != null) {
                        AndroidClassDefiner.delete(apkFile);
                    }
                    if (tempDir != null) {
                        AndroidClassDefiner.delete(tempDir);
                    }
                    throw throwable;
                }
            }
            AndroidClassDefiner.delete(apkFile);
        }
        if (tempDir != null) {
            AndroidClassDefiner.delete(tempDir);
        }
        return clazz;
    }
}

