/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.GraphicsUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.UnsupportedEncodingException;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VectorGraphics2D
extends Graphics2D {
    private final StringBuffer a;
    private final Rectangle2D b;
    private double c;
    private int d;
    private FontRendering e;
    private boolean f;
    private final RenderingHints g = new RenderingHints(new HashMap());
    private Color h;
    private Color i;
    private Shape j;
    private Composite k;
    private final GraphicsConfiguration l;
    private Font m;
    private final FontRenderContext n;
    private Paint o;
    private Stroke p;
    private final AffineTransform q;

    public VectorGraphics2D(double d, double d2, double d3, double d4) {
        this.a = new StringBuffer();
        this.b = new Rectangle2D.Double(d, d2, d3, d4);
        this.e = FontRendering.TEXT;
        this.c = 72.0;
        this.d = 128;
        this.h = Color.WHITE;
        this.i = Color.BLACK;
        this.k = AlphaComposite.getInstance(1);
        this.l = null;
        this.m = Font.decode(null);
        this.n = new FontRenderContext(null, false, true);
        this.o = this.i;
        this.p = new BasicStroke(1.0f);
        this.q = new AffineTransform();
        this.f = false;
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.g.putAll(map);
    }

    @Override
    public void clip(Shape shape) {
        if (this.getClip() != null && shape != null) {
            Area area = new Area(this.getClip());
            shape = new Area(shape);
            ((Area)shape).intersect(area);
        }
        this.setClip(shape);
    }

    @Override
    public void draw(Shape shape) {
        this.writeShape(shape);
        this.writeClosingDraw(shape);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.draw(glyphVector.getOutline(f, f2));
    }

    @Override
    public boolean drawImage(Image object, AffineTransform object2, ImageObserver object3) {
        object3 = object2;
        object2 = object;
        object = this;
        object = (Integer)((VectorGraphics2D)object).g.get(RenderingHints.KEY_INTERPOLATION);
        object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(object) ? Integer.valueOf(1) : (RenderingHints.VALUE_INTERPOLATION_BILINEAR.equals(object) ? Integer.valueOf(2) : Integer.valueOf(3));
        object = new AffineTransformOp((AffineTransform)object3, (Integer)object);
        object2 = GraphicsUtils.toBufferedImage((Image)object2);
        object = ((AffineTransformOp)object).filter((BufferedImage)object2, null);
        this.drawImage((BufferedImage)object, null, ((BufferedImage)object).getMinX(), ((BufferedImage)object).getMinY());
        return true;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        this.drawImage(bufferedImage, n, n2, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(String object, float f, float f2) {
        if (object != null && ((String)object).trim().isEmpty()) {
            return;
        }
        switch (this.getFontRendering()) {
            case VECTORS: {
                object = new TextLayout((String)object, this.getFont(), this.getFontRenderContext());
                object = ((TextLayout)object).getOutline(AffineTransform.getTranslateInstance(f, f2));
                this.fill((Shape)object);
                return;
            }
            case TEXT: {
                this.writeString((String)object, f, f2);
                return;
            }
        }
        throw new IllegalStateException("Unknown font rendering mode.");
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.drawString(stringBuffer.toString(), f, f2);
    }

    @Override
    public void fill(Shape shape) {
        this.writeShape(shape);
        this.writeClosingFill(shape);
    }

    @Override
    public Color getBackground() {
        return this.h;
    }

    @Override
    public Composite getComposite() {
        return this.k;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.n;
    }

    @Override
    public Paint getPaint() {
        return this.o;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        if (RenderingHints.KEY_ANTIALIASING.equals(key)) {
            return RenderingHints.VALUE_ANTIALIAS_OFF;
        }
        if (RenderingHints.KEY_TEXT_ANTIALIASING.equals(key)) {
            return RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        }
        if (RenderingHints.KEY_FRACTIONALMETRICS.equals(key)) {
            return RenderingHints.VALUE_FRACTIONALMETRICS_ON;
        }
        return this.g.get(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g;
    }

    @Override
    public Stroke getStroke() {
        return this.p;
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.getStroke().createStrokedShape(shape);
            return shape.intersects(rectangle);
        }
        return shape.intersects(rectangle);
    }

    @Override
    public void setBackground(Color color) {
        this.h = color;
    }

    @Override
    public void setComposite(Composite composite) {
        this.k = composite;
    }

    @Override
    public void setPaint(Paint colorArray) {
        if (colorArray != null) {
            this.o = colorArray;
            if (colorArray instanceof Color) {
                this.setColor((Color)colorArray);
                return;
            }
            if (colorArray instanceof MultipleGradientPaint) {
                if ((colorArray = ((MultipleGradientPaint)colorArray).getColors()).length == 1) {
                    this.setColor(colorArray[0]);
                    return;
                }
                if (colorArray.length > 1) {
                    Color color = colorArray[0];
                    float f = VectorGraphics2D.a(color);
                    int n = color.getAlpha();
                    for (int i = 1; i < colorArray.length; ++i) {
                        Color color2 = colorArray[i];
                        float f2 = VectorGraphics2D.a(color2);
                        int n2 = color2.getAlpha();
                        if (!(f2 < f) && n2 >= n) continue;
                        color = color2;
                        f = f2;
                    }
                    this.setColor(color);
                }
            }
        }
    }

    private static float a(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[2];
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.g.put(key, object);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.g.putAll(map);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.p = stroke;
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.q);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.setAffineTransform(affineTransform);
    }

    protected void setAffineTransform(AffineTransform affineTransform) {
        if (!this.q.equals(affineTransform)) {
            this.q.setTransform(affineTransform);
            this.f = true;
        }
    }

    @Override
    public void shear(double d, double d2) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.shear(d, d2);
        this.setAffineTransform(affineTransform);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        affineTransform2.concatenate(affineTransform);
        this.setAffineTransform(affineTransform2);
    }

    @Override
    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    @Override
    public void translate(double d, double d2) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(d, d2);
        this.setAffineTransform(affineTransform);
    }

    @Override
    public void rotate(double d) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.rotate(d);
        this.setAffineTransform(affineTransform);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.rotate(d, d2, d3);
        this.setAffineTransform(affineTransform);
    }

    @Override
    public void scale(double d, double d2) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.scale(d, d2);
        this.setAffineTransform(affineTransform);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        int n5 = image.getWidth(imageObserver);
        int n6 = image.getHeight(imageObserver);
        this.writeImage(image, n5, n6, n, n2, n3, n4);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n9 = Math.min(n5, n7);
        int n10 = Math.min(n6, n8);
        n5 = Math.abs(n7 - n5);
        n6 = Math.abs(n8 - n6);
        n7 = Math.min(n, n3);
        n8 = Math.min(n2, n4);
        n = Math.abs(n3 - n);
        n2 = Math.abs(n4 - n2);
        image = GraphicsUtils.toBufferedImage(image);
        image = ((BufferedImage)image).getSubimage(n9, n10, n5, n6);
        return this.drawImage(image, n7, n8, n, n2, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n9 = Math.min(n5, n7);
        int n10 = Math.min(n6, n8);
        n5 = Math.abs(n7 - n5);
        n6 = Math.abs(n8 - n6);
        n7 = Math.min(n, n3);
        n8 = Math.min(n2, n4);
        n = Math.abs(n3 - n);
        n2 = Math.abs(n4 - n2);
        Color color2 = this.getColor();
        this.setColor(color);
        this.fill(new Rectangle(n7, n8, n, n2));
        this.setColor(color2);
        image = GraphicsUtils.toBufferedImage(image);
        image = ((BufferedImage)image).getSubimage(n9, n10, n5, n6);
        return this.drawImage(image, n7, n8, n, n2, imageObserver);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Double(n, n2, n3, n4));
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Double(n, n2, n3, n4));
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Path2D.Float float_ = new Path2D.Float();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((Path2D)float_).lineTo(nArray[i], nArray2[i]);
                continue;
            }
            ((Path2D)float_).moveTo(nArray[i], nArray2[i]);
        }
        float_.closePath();
        this.draw(float_);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Path2D.Float float_ = new Path2D.Float();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((Path2D)float_).lineTo(nArray[i], nArray2[i]);
                continue;
            }
            ((Path2D)float_).moveTo(nArray[i], nArray2[i]);
        }
        this.draw(float_);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle2D.Double(n, n2, n3, n4));
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 2));
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Double(n, n2, n3, n4));
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Path2D.Float float_ = new Path2D.Float();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((Path2D)float_).lineTo(nArray[i], nArray2[i]);
                continue;
            }
            ((Path2D)float_).moveTo(nArray[i], nArray2[i]);
        }
        float_.closePath();
        this.fill(float_);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle2D.Double(n, n2, n3, n4));
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    @Override
    public Shape getClip() {
        return this.j;
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.j == null) {
            return null;
        }
        return this.j.getBounds();
    }

    @Override
    public Color getColor() {
        return this.i;
    }

    @Override
    public Font getFont() {
        return this.m;
    }

    @Override
    public FontMetrics getFontMetrics(Font object) {
        object = new BufferedImage(1, 1, 3);
        object = ((BufferedImage)object).getGraphics();
        FontMetrics fontMetrics = ((Graphics)object).getFontMetrics(this.m);
        ((Graphics)object).dispose();
        return fontMetrics;
    }

    @Override
    public void setClip(Shape shape) {
        this.j = shape;
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setColor(Color color) {
        this.i = color;
    }

    @Override
    public void setFont(Font font) {
        if (!this.m.equals(font)) {
            this.m = font;
        }
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    protected void write(Object ... objectArray) {
        for (Object object : objectArray) {
            String string = object.toString();
            if (object instanceof Double || object instanceof Float) {
                string = String.format(Locale.ENGLISH, "%.7f", object).replaceAll("\\.?0+$", "");
            }
            this.a.append(string);
        }
    }

    protected void writeln(Object ... objectArray) {
        this.write(objectArray);
        this.write("\n");
    }

    protected abstract void writeShape(Shape var1);

    protected abstract void writeImage(Image var1, int var2, int var3, double var4, double var6, double var8, double var10);

    protected abstract void writeString(String var1, double var2, double var4);

    protected abstract void writeClosingDraw(Shape var1);

    protected void writeClosingFill(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        int n = (int)Math.ceil(rectangle2D.getWidth() * this.getResolution());
        int n2 = (int)Math.ceil(rectangle2D.getHeight() * this.getResolution());
        n = Math.min(n, this.d);
        n2 = Math.min(n2, this.d);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.scale((double)n / rectangle2D.getWidth(), (double)n2 / rectangle2D.getHeight());
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        graphics2D.setPaint(this.getPaint());
        graphics2D.fill(shape);
        graphics2D.dispose();
        this.writeImage(bufferedImage, n, n2, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected abstract void writeHeader();

    protected abstract String getFooter();

    protected boolean isDistorted() {
        if (!this.isTransformed()) {
            return false;
        }
        int n = this.q.getType();
        return (n & 0xFFFFFFF8) != 0;
    }

    @Override
    public String toString() {
        return this.a.toString() + this.getFooter();
    }

    public byte[] getBytes() {
        try {
            return this.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.toString().getBytes();
        }
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setFrame(this.b);
        return double_;
    }

    protected int size() {
        return this.a.length();
    }

    public FontRendering getFontRendering() {
        return this.e;
    }

    public void setFontRendering(FontRendering fontRendering) {
        this.e = fontRendering;
    }

    protected boolean isTransformed() {
        return this.f;
    }

    public double getResolution() {
        return this.c;
    }

    public void setResolution(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Only positive non-zero values allowed");
        }
        this.c = d;
    }

    public int getRasteredImageSizeMaximum() {
        return this.d;
    }

    public void setRasteredImageSizeMaximum(int n) {
        this.d = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontRendering {
        TEXT,
        VECTORS;

    }
}

