/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.DataUtils;
import de.erichseifert.vectorgraphics2d.GraphicsUtils;
import de.erichseifert.vectorgraphics2d.VectorGraphics2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;

public class SVGGraphics2D
extends VectorGraphics2D {
    private static final Map<Integer, String> a = DataUtils.map(new Integer[]{0, 1, 2}, new String[]{"butt", "round", "square"});
    private static final Map<Integer, String> b = DataUtils.map(new Integer[]{0, 1, 2}, new String[]{"miter", "round", "bevel"});
    private long c;

    public SVGGraphics2D(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.writeHeader();
    }

    protected void writeString(String string, double d, double d2) {
        string = string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        float f = this.getFont().getSize2D();
        string = string.replaceAll("[\r\n]", "");
        this.writeln("<text x=\"", d, "\" y=\"", d2, "\" style=\"font:", Float.valueOf(f), "px ", this.getFont().getFamily(), "\">", string, "</text>");
    }

    protected void writeImage(Image object, int n, int n2, double d, double d2, double d3, double d4) {
        object = GraphicsUtils.toBufferedImage((Image)object);
        object = SVGGraphics2D.a((BufferedImage)object);
        this.write("<image x=\"", d, "\" y=\"", d2, "\" ", "width=\"", d3, "\" height=\"", d4, "\" ", "xlink:href=\"", object, "\" ", "/>");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Path2D.Double double_ = new Path2D.Double(1, nArray.length);
        this.write("<polygon points=\"");
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                ((Path2D)double_).moveTo(nArray[i], nArray2[i]);
            } else {
                ((Path2D)double_).lineTo(nArray[i], nArray2[i]);
                this.write(" ");
            }
            this.write(nArray[i], ",", nArray2[i]);
        }
        this.write("\" ");
        double_.closePath();
        this.writeClosingDraw(double_);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Path2D.Double double_ = new Path2D.Double(1, nArray.length);
        this.write("<polyline points=\"");
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                ((Path2D)double_).moveTo(nArray[i], nArray2[i]);
            } else {
                ((Path2D)double_).lineTo(nArray[i], nArray2[i]);
                this.write(" ");
            }
            this.write(nArray[i], ",", nArray2[i]);
        }
        this.write("\" ");
        this.writeClosingDraw(double_);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Path2D.Double double_ = new Path2D.Double(1, nArray.length);
        this.write("<polygon points=\"");
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                ((Path2D)double_).moveTo(nArray[i], nArray2[i]);
            } else {
                ((Path2D)double_).lineTo(nArray[i], nArray2[i]);
                this.write(" ");
            }
            this.write(nArray[i], ",", nArray2[i]);
        }
        this.write("\" ");
        double_.closePath();
        this.writeClosingFill(double_);
    }

    public void setClip(Shape shape) {
        super.setClip(shape);
        if (this.getClip() != null) {
            this.writeln("<clipPath id=\"", "clip", ++this.c, "\">");
            this.writeShape(this.getClip());
            this.writeln("/>");
            this.writeln("</clipPath>");
        }
    }

    protected void setAffineTransform(AffineTransform object) {
        if (this.getTransform().equals(object)) {
            return;
        }
        if (this.isTransformed()) {
            this.writeln("</g>");
        }
        super.setAffineTransform((AffineTransform)object);
        if (this.isTransformed()) {
            object = new double[6];
            this.getTransform().getMatrix((double[])object);
            this.write("<g transform=\"matrix(", DataUtils.join(" ", (double[])object), ") \">");
        }
    }

    protected void writeHeader() {
        Rectangle2D rectangle2D = this.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        this.writeln("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeln("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" ", "\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
        this.writeln("<svg version=\"1.2\" xmlns=\"http://www.w3.org/2000/svg\" ", "xmlns:xlink=\"http://www.w3.org/1999/xlink\" ", "x=\"", d, "mm\" y=\"", d2, "mm\" ", "width=\"", d3, "mm\" height=\"", d4, "mm\" viewBox=\"", d, " ", d2, " ", d3, " ", d4, "\"", ">");
        this.writeln("<style type=\"text/css\"><![CDATA[");
        this.writeln("text { font:", Float.valueOf(this.getFont().getSize2D()), "px ", this.getFont().getFamily(), "; }");
        this.writeln("]]></style>");
    }

    protected void writeClosingDraw(Shape object) {
        this.write("style=\"fill:none;stroke:", SVGGraphics2D.a(this.getColor()));
        if (this.getStroke() instanceof BasicStroke) {
            object = (BasicStroke)this.getStroke();
            if (((BasicStroke)object).getLineWidth() != 1.0f) {
                this.write(";stroke-width:", Float.valueOf(((BasicStroke)object).getLineWidth()));
            }
            if (((BasicStroke)object).getEndCap() != 0) {
                this.write(";stroke-linecap:", a.get(((BasicStroke)object).getEndCap()));
            }
            if (((BasicStroke)object).getLineJoin() != 0) {
                this.write(";stroke-linejoin:", b.get(((BasicStroke)object).getLineJoin()));
            }
            if (((BasicStroke)object).getDashArray() != null && ((BasicStroke)object).getDashArray().length > 0) {
                this.write(";stroke-dasharray:", DataUtils.join(",", ((BasicStroke)object).getDashArray()));
                this.write(";stroke-dashoffset:", Float.valueOf(((BasicStroke)object).getDashPhase()));
            }
        }
        if (this.getClip() != null) {
            this.write("\" clip-path=\"url(#", "clip", this.c, ")");
        }
        this.writeln("\" />");
    }

    protected void writeClosingFill(Shape shape) {
        if (this.getPaint() instanceof Color) {
            this.write("style=\"fill:", SVGGraphics2D.a(this.getColor()), ";stroke:none");
            if (this.getClip() != null) {
                this.write("\" clip-path=\"url(#", "clip", this.c, ")");
            }
            this.writeln("\" />");
            return;
        }
        this.write("style=\"stroke:none\" />");
        super.writeClosingFill(shape);
    }

    protected void writeShape(Shape object) {
        if (object instanceof Line2D) {
            object = (Line2D)object;
            double d = ((Line2D)object).getX1();
            double d2 = ((Line2D)object).getY1();
            double d3 = ((Line2D)object).getX2();
            double d4 = ((Line2D)object).getY2();
            this.write("<line x1=\"", d, "\" y1=\"", d2, "\" x2=\"", d3, "\" y2=\"", d4, "\" ");
            return;
        }
        if (object instanceof Rectangle2D) {
            object = (Rectangle2D)object;
            double d = ((RectangularShape)object).getX();
            double d5 = ((RectangularShape)object).getY();
            double d6 = ((RectangularShape)object).getWidth();
            double d7 = ((RectangularShape)object).getHeight();
            this.write("<rect x=\"", d, "\" y=\"", d5, "\" width=\"", d6, "\" height=\"", d7, "\" ");
            return;
        }
        if (object instanceof RoundRectangle2D) {
            object = (RoundRectangle2D)object;
            double d = ((RectangularShape)object).getX();
            double d8 = ((RectangularShape)object).getY();
            double d9 = ((RectangularShape)object).getWidth();
            double d10 = ((RectangularShape)object).getHeight();
            double d11 = ((RoundRectangle2D)object).getArcWidth();
            double d12 = ((RoundRectangle2D)object).getArcHeight();
            this.write("<rect x=\"", d, "\" y=\"", d8, "\" width=\"", d9, "\" height=\"", d10, "\" rx=\"", d11, "\" ry=\"", d12, "\" ");
            return;
        }
        if (object instanceof Ellipse2D) {
            object = (Ellipse2D)object;
            double d = ((RectangularShape)object).getX();
            double d13 = ((RectangularShape)object).getY();
            double d14 = ((RectangularShape)object).getWidth() / 2.0;
            double d15 = ((RectangularShape)object).getHeight() / 2.0;
            this.write("<ellipse cx=\"", d + d14, "\" cy=\"", d13 + d15, "\" rx=\"", d14, "\" ry=\"", d15, "\" ");
            return;
        }
        this.write("<path d=\"");
        object = object.getPathIterator(null);
        double[] dArray = new double[6];
        int n = 0;
        while (!object.isDone()) {
            if (n > 0) {
                this.write(" ");
            }
            int n2 = object.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    this.write("M", dArray[0], ",", dArray[1]);
                    break;
                }
                case 1: {
                    this.write("L", dArray[0], ",", dArray[1]);
                    break;
                }
                case 3: {
                    this.write("C", dArray[0], ",", dArray[1], " ", dArray[2], ",", dArray[3], " ", dArray[4], ",", dArray[5]);
                    break;
                }
                case 2: {
                    this.write("Q", dArray[0], ",", dArray[1], " ", dArray[2], ",", dArray[3]);
                    break;
                }
                case 4: {
                    this.write("Z");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++n;
            object.next();
        }
        this.write("\" ");
    }

    private static String a(Color color) {
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        if (color.getAlpha() < 255) {
            double d = (double)color.getAlpha() / 255.0;
            string = string + ";opacity:" + d;
        }
        return string;
    }

    private static String a(BufferedImage object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)object, "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return "";
        }
        object = DatatypeConverter.printBase64Binary((byte[])byteArrayOutputStream.toByteArray());
        return "data:image/png;base64," + (String)object;
    }

    protected String getFooter() {
        String string = "";
        if (this.isTransformed()) {
            string = string + "</g>\n";
        }
        string = string + "</svg>\n";
        return string;
    }

    public String toString() {
        String string = super.toString();
        string = string.replaceAll("<g transform=\"[^\"]*\"></g>\n", "");
        return string;
    }
}

