/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public abstract class GraphicsUtils {
    protected GraphicsUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasAlpha(Image object) {
        if (object instanceof BufferedImage) {
            object = (BufferedImage)object;
            return ((BufferedImage)object).getColorModel().hasAlpha();
        }
        object = new PixelGrabber((Image)object, 0, 0, 1, 1, false);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        object = ((PixelGrabber)object).getColorModel();
        return ((ColorModel)object).hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        int n;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = GraphicsUtils.hasAlpha(image);
        Object object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            n = 1;
            if (bl) {
                n = 2;
            }
            object = ((GraphicsEnvironment)object).getDefaultScreenDevice();
            object = ((GraphicsDevice)object).getDefaultConfiguration();
            object = ((GraphicsConfiguration)object).createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            object = null;
        }
        if (object == null) {
            n = 1;
            if (bl) {
                n = 2;
            }
            object = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return object;
    }
}

