/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class GraphicsUtils {
    private static final FontRenderContext a = new FontRenderContext(null, true, true);

    protected GraphicsUtils() {
        throw new UnsupportedOperationException();
    }

    public static TextLayout getLayout(String string, Font font) {
        return new TextLayout(string, font, a);
    }

    public static void fillPaintedShape(Graphics2D graphics2D, Shape shape, Paint object, Rectangle2D rectangle2D) {
        if (shape == null) {
            return;
        }
        if (rectangle2D == null) {
            rectangle2D = shape.getBounds2D();
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        graphics2D.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
        Paint paint = null;
        if (object != null) {
            paint = graphics2D.getPaint();
            graphics2D.setPaint((Paint)object);
        }
        object = AffineTransform.getScaleInstance(1.0 / rectangle2D.getWidth(), 1.0 / rectangle2D.getHeight());
        ((AffineTransform)object).translate(-rectangle2D.getX(), -rectangle2D.getY());
        graphics2D.fill(((AffineTransform)object).createTransformedShape(shape));
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        graphics2D.setTransform(affineTransform);
    }

    public static void drawPaintedShape(Graphics2D graphics2D, Shape shape, Paint paint, Rectangle2D rectangle2D, Stroke stroke) {
        if (shape == null) {
            return;
        }
        if (stroke == null) {
            stroke = graphics2D.getStroke();
        }
        shape = stroke.createStrokedShape(shape);
        GraphicsUtils.fillPaintedShape(graphics2D, shape, paint, rectangle2D);
    }
}

