/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.util.MathUtils;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeometryUtils {
    public static final double EPSILON = 1.0E-5;
    public static final double EPSILON_SQ = 1.0000000000000002E-10;

    protected GeometryUtils() {
        throw new UnsupportedOperationException();
    }

    public static Line2D[] shapeToLines(Shape object, boolean bl) {
        ArrayDeque<Cloneable> arrayDeque = new ArrayDeque<Cloneable>();
        object = new FlatteningPathIterator(object.getPathIterator(null), 0.5);
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        while (!object.isDone()) {
            Cloneable cloneable;
            Cloneable cloneable2;
            int n = object.currentSegment(dArray);
            if (n == 1 || n == 4) {
                if (!bl) {
                    cloneable2 = new Line2D.Double(dArray2[0], dArray2[1], dArray[0], dArray[1]);
                    arrayDeque.addLast(cloneable2);
                } else {
                    cloneable2 = new Line2D.Double(dArray[0], dArray[1], dArray2[0], dArray2[1]);
                    arrayDeque.addFirst(cloneable2);
                }
            }
            if (n == 4 && !arrayDeque.isEmpty() && !((Point2D)(cloneable2 = ((Line2D)arrayDeque.getFirst()).getP1())).equals(cloneable = ((Line2D)arrayDeque.getLast()).getP2())) {
                if (!bl) {
                    cloneable = new Line2D.Double(dArray[0], dArray[1], ((Point2D)cloneable2).getX(), ((Point2D)cloneable2).getY());
                    arrayDeque.addLast(cloneable);
                } else {
                    cloneable = new Line2D.Double(((Point2D)cloneable2).getX(), ((Point2D)cloneable2).getY(), dArray[0], dArray[1]);
                    arrayDeque.addFirst(cloneable);
                }
            }
            System.arraycopy(dArray, 0, dArray2, 0, 6);
            object.next();
        }
        Line2D[] line2DArray = new Line2D[arrayDeque.size()];
        arrayDeque.toArray(line2DArray);
        return line2DArray;
    }

    public static List<Point2D> intersection(Shape line2DArray, Shape line2DArray2) {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(2);
        line2DArray = GeometryUtils.shapeToLines((Shape)line2DArray, false);
        line2DArray2 = GeometryUtils.shapeToLines((Shape)line2DArray2, false);
        for (Line2D line2D : line2DArray) {
            Line2D[] line2DArray3 = line2DArray2;
            int n = line2DArray2.length;
            for (int i = 0; i < n; ++i) {
                Cloneable cloneable = line2DArray3[i];
                if ((cloneable = GeometryUtils.intersection(line2D, cloneable)) == null) continue;
                arrayList.add((Point2D)cloneable);
            }
        }
        return arrayList;
    }

    public static Point2D intersection(Line2D cloneable, Line2D cloneable2) {
        double d;
        double d2;
        Point2D point2D = ((Line2D)cloneable).getP1();
        cloneable = new Point2D.Double(((Line2D)cloneable).getX2() - point2D.getX(), ((Line2D)cloneable).getY2() - point2D.getY());
        Point2D point2D2 = ((Line2D)cloneable2).getP1();
        cloneable2 = new Point2D.Double(((Line2D)cloneable2).getX2() - point2D2.getX(), ((Line2D)cloneable2).getY2() - point2D2.getY());
        point2D2 = new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        double d3 = ((Point2D)cloneable).getX() * ((Point2D)cloneable2).getY() - ((Point2D)cloneable).getY() * ((Point2D)cloneable2).getX();
        double d4 = d3 * d3;
        if (d4 > (d2 = ((Point2D)cloneable).distanceSq(0.0, 0.0)) * 1.0000000000000002E-10 * (d = ((Point2D)cloneable2).distanceSq(0.0, 0.0))) {
            double d5 = (point2D2.getX() * ((Point2D)cloneable2).getY() - point2D2.getY() * ((Point2D)cloneable2).getX()) / d3;
            if (d5 < 0.0 || d5 > 1.0) {
                return null;
            }
            double d6 = (point2D2.getX() * ((Point2D)cloneable).getY() - point2D2.getY() * ((Point2D)cloneable).getX()) / d3;
            if (d6 < 0.0 || d6 > 1.0) {
                return null;
            }
            return new Point2D.Double(point2D.getX() + d5 * ((Point2D)cloneable).getX(), point2D.getY() + d5 * ((Point2D)cloneable).getY());
        }
        return null;
    }

    public static Area grow(Shape shape, double d) {
        return GeometryUtils.grow(shape, d, 0, 10.0f);
    }

    public static Area grow(Shape shape, double d, int n, float f) {
        Area area = new Area(shape);
        if (MathUtils.almostEqual(d, 0.0, 1.0E-5)) {
            return area;
        }
        BasicStroke basicStroke = new BasicStroke((float)Math.abs(d * 2.0), 2, n, f);
        shape = new Area(basicStroke.createStrokedShape(shape));
        if (d > 0.0) {
            area.add((Area)shape);
        } else {
            area.subtract((Area)shape);
        }
        return area;
    }

    public static Area punch(Shape shape, double d, boolean bl, Iterable<DataPoint> object) {
        shape = new Area(shape);
        if (d > 1.0E-10) {
            bl = bl;
            Area area = new Area();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (DataPoint)object.next();
                Shape shape2 = ((DataPoint)object2).getPoint();
                if (shape2 == null) continue;
                object2 = ((DataPoint)object2).getPosition().getPoint2D();
                object2 = GeometryUtils.grow(AffineTransform.getTranslateInstance(((Point2D)object2).getX(), ((Point2D)object2).getY()).createTransformedShape(shape2), d, bl ? 1 : 0, 10.0f);
                area.add((Area)object2);
            }
            ((Area)shape).subtract(area);
        }
        return shape;
    }
}

