/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import de.erichseifert.gral.util.SettingChangeEvent;
import de.erichseifert.gral.util.SettingsListener;
import de.erichseifert.gral.util.SettingsStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSettingsStorage
implements SettingsStorage {
    private final Set<SettingsListener> a = new HashSet<SettingsListener>();
    private final Map<SettingsStorage.Key, Object> b = new HashMap<SettingsStorage.Key, Object>();
    private final Map<SettingsStorage.Key, Object> c = new HashMap<SettingsStorage.Key, Object>();

    public boolean hasSetting(SettingsStorage.Key key) {
        return this.b.containsKey(key);
    }

    @Override
    public <T> T getSetting(SettingsStorage.Key key) {
        if (this.b.containsKey(key)) {
            return (T)this.b.get(key);
        }
        return (T)this.c.get(key);
    }

    @Override
    public <T> void setSetting(SettingsStorage.Key key, T t) {
        Object object = this.b.get(key);
        this.b.put(key, t);
        this.notifySettingChanged(key, object, t, false);
    }

    @Override
    public <T> void removeSetting(SettingsStorage.Key key) {
        Object object = this.b.get(key);
        this.b.remove(key);
        this.notifySettingChanged(key, object, null, false);
    }

    public boolean hasSettingDefault(SettingsStorage.Key key) {
        return this.c.containsKey(key);
    }

    @Override
    public <T> void setSettingDefault(SettingsStorage.Key key, T t) {
        Object object = this.c.get(key);
        this.c.put(key, t);
        this.notifySettingChanged(key, object, t, true);
    }

    @Override
    public <T> void removeSettingDefault(SettingsStorage.Key key) {
        Object object = this.c.get(key);
        this.c.remove(key);
        this.notifySettingChanged(key, object, null, true);
    }

    public void addSettingsListener(SettingsListener settingsListener) {
        this.a.add(settingsListener);
    }

    public void removeSettingsListener(SettingsListener settingsListener) {
        this.a.remove(settingsListener);
    }

    protected void notifySettingChanged(SettingsStorage.Key serializable, Object iterator, Object object, boolean bl) {
        serializable = new SettingChangeEvent(this, (SettingsStorage.Key)serializable, iterator, object, bl);
        iterator = this.a.iterator();
        while (iterator.hasNext()) {
            iterator.next().settingChanged((SettingChangeEvent)serializable);
        }
    }
}

