/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.ui;

import de.erichseifert.gral.Drawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.plots.DrawableWriterFactory;
import de.erichseifert.gral.plots.NavigationListener;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.PlotNavigator;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.ui.DrawablePanel;
import de.erichseifert.gral.ui.DrawableWriterFilter;
import de.erichseifert.gral.ui.ExportChooser;
import de.erichseifert.gral.ui.ExportDialog;
import de.erichseifert.gral.util.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class InteractivePanel
extends DrawablePanel
implements NavigationListener,
Printable {
    private static final long serialVersionUID = 1L;
    private final PrinterJob a = PrinterJob.getPrinterJob();
    private boolean b;
    private boolean c;
    private final JPopupMenu d;
    private final JMenuItem e;
    private final JMenuItem f;
    private final JMenuItem g;
    private final JMenuItem h;
    private final JMenuItem i;
    private final JFileChooser j;
    private PlotNavigator k;
    private c l;
    private b m;

    public InteractivePanel(Drawable object) {
        super((Drawable)object);
        this.a.setPrintable(this);
        object = DrawableWriterFactory.getInstance().getCapabilities();
        this.j = new ExportChooser(true, (List<IOCapabilities>)object);
        this.j.setDialogTitle(Messages.getString("InteractivePanel.exportImageTitle"));
        this.d = new JPopupMenu();
        this.e = new JMenuItem(new AbstractAction(this, Messages.getString("InteractivePanel.zoomIn")){
            private /* synthetic */ InteractivePanel a;
            {
                this.a = interactivePanel;
                super(string);
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                InteractivePanel.a(this.a, 1.0);
            }
        });
        this.d.add(this.e);
        this.f = new JMenuItem(new AbstractAction(this, Messages.getString("InteractivePanel.zoomOut")){
            private /* synthetic */ InteractivePanel a;
            {
                this.a = interactivePanel;
                super(string);
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                InteractivePanel.a(this.a, -1.0);
            }
        });
        this.d.add(this.f);
        this.g = new JMenuItem(new AbstractAction(this, Messages.getString("InteractivePanel.resetView")){
            private /* synthetic */ InteractivePanel a;
            {
                this.a = interactivePanel;
                super(string);
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                if (this.a.k != null) {
                    this.a.k.reset();
                    this.a.repaint();
                }
            }
        });
        this.d.add(this.g);
        this.d.addSeparator();
        this.h = new JMenuItem(new AbstractAction(this, Messages.getString("InteractivePanel.exportImage")){
            private /* synthetic */ InteractivePanel a;
            {
                this.a = interactivePanel;
                super(string);
            }

            /*
             * Loose catch block
             */
            public final void actionPerformed(ActionEvent actionEvent) {
                int n = this.a.j.showSaveDialog(this.a);
                this.a.repaint();
                if (n != 0) {
                    return;
                }
                Object object = this.a.j.getSelectedFile();
                if (object == null) {
                    return;
                }
                if (((File)object).exists()) {
                    int n2 = JOptionPane.showConfirmDialog(this.a, Messages.getString("InteractivePanel.exportExistsWarning"), Messages.getString("InteractivePanel.warning"), 0);
                    this.a.repaint();
                    if (n2 == 1) {
                        return;
                    }
                }
                Object object2 = this.a.getDrawable();
                Object object3 = new ExportDialog(this.a, (Drawable)object2);
                ((Dialog)object3).setVisible(true);
                if (!((ExportDialog)object3).getUserAction().equals((Object)ExportDialog.UserAction.APPROVE)) {
                    return;
                }
                Object object4 = (DrawableWriterFilter)this.a.j.getFileFilter();
                Drawable drawable = object2;
                String string = ((DrawableWriterFilter)object4).getWriterCapabilities().getMimeType();
                object4 = ((ExportDialog)object3).getDocumentBounds();
                object3 = object;
                object2 = string;
                object = drawable;
                Object object5 = object2;
                Serializable serializable = object3;
                object3 = object4;
                object2 = serializable;
                object = object5;
                object4 = drawable;
                try {
                    object2 = new FileOutputStream((File)object2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    return;
                }
                object = DrawableWriterFactory.getInstance().get((String)object);
                object.write((Drawable)object4, (OutputStream)object2, ((RectangularShape)object3).getX(), ((RectangularShape)object3).getY(), ((RectangularShape)object3).getWidth(), ((RectangularShape)object3).getHeight());
                try {
                    ((FileOutputStream)object2).close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
                catch (IOException iOException) {
                    try {
                        iOException.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            ((FileOutputStream)object2).close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        ((FileOutputStream)object2).close();
                        return;
                    }
                    catch (IOException iOException3) {
                        iOException3.printStackTrace();
                        return;
                    }
                }
            }
        });
        this.d.add(this.h);
        this.i = new JMenuItem(new AbstractAction(this, Messages.getString("InteractivePanel.print")){
            private /* synthetic */ InteractivePanel a;
            {
                this.a = interactivePanel;
                super(string);
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                if (this.a.a.printDialog()) {
                    try {
                        this.a.a.print();
                        return;
                    }
                    catch (PrinterException printerException) {
                        printerException.printStackTrace();
                    }
                }
            }
        });
        this.d.add(this.i);
        this.addMouseListener(new a(this.d));
        if (this.getDrawable() instanceof Plot) {
            object = (Plot)this.getDrawable();
            this.k = new PlotNavigator((Plot)object);
            this.setZoomable(true);
            if (this.getDrawable() instanceof XYPlot) {
                this.setPannable(true);
            }
        }
    }

    public int print(Graphics graphics, PageFormat cloneable, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        graphics = (Graphics2D)graphics;
        AffineTransform affineTransform = ((Graphics2D)graphics).getTransform();
        ((Graphics2D)graphics).scale(0.5669291338582678, 0.5669291338582678);
        Rectangle2D rectangle2D = this.getDrawable().getBounds();
        cloneable = new Rectangle2D.Double(cloneable.getImageableX() / 0.5669291338582678, cloneable.getImageableY() / 0.5669291338582678, cloneable.getImageableWidth() / 0.5669291338582678, cloneable.getImageableHeight() / 0.5669291338582678);
        this.getDrawable().setBounds((Rectangle2D)cloneable);
        try {
            this.getDrawable().draw(new DrawingContext((Graphics2D)graphics));
        }
        finally {
            this.getDrawable().setBounds(rectangle2D);
        }
        ((Graphics2D)graphics).setTransform(affineTransform);
        return 0;
    }

    public void connect(InteractivePanel interactivePanel) {
        if (interactivePanel != null && interactivePanel != this) {
            this.k.addNavigationListener(interactivePanel);
            interactivePanel.k.addNavigationListener(this);
        }
    }

    public void disconnect(InteractivePanel interactivePanel) {
        if (interactivePanel != null && interactivePanel != this) {
            this.k.removeNavigationListener(interactivePanel);
            interactivePanel.k.removeNavigationListener(this);
        }
    }

    public void centerChanged(PlotNavigator plotNavigator, String string, Number number, Number number2) {
        this.k.setCenter(string, number2);
        this.repaint();
    }

    public void zoomChanged(PlotNavigator plotNavigator, String string, double d, double d2) {
        this.k.setZoom(d2);
        this.repaint();
    }

    public boolean isZoomable() {
        return this.b;
    }

    public void setZoomable(boolean bl) {
        if (!(this.getDrawable() instanceof Plot) || this.b == bl) {
            return;
        }
        this.b = bl;
        if (this.l != null) {
            this.removeMouseWheelListener(this.l);
            this.removeMouseListener(this.l);
            this.l = null;
        }
        if (bl) {
            this.l = new c(this);
            this.addMouseListener(this.l);
            this.addMouseWheelListener(this.l);
        }
        this.e.setEnabled(this.isZoomable());
        this.f.setEnabled(this.isZoomable());
        this.g.setEnabled(this.isZoomable() && this.isPannable());
    }

    public boolean isPannable() {
        return this.c;
    }

    public void setPannable(boolean bl) {
        if (!(this.getDrawable() instanceof XYPlot) || this.c == bl) {
            return;
        }
        this.c = bl;
        if (this.m != null) {
            this.removeMouseMotionListener(this.m);
            this.removeMouseListener(this.m);
            this.m = null;
        }
        if (bl) {
            this.m = new b(this.k);
            this.addMouseListener(this.m);
            this.addMouseMotionListener(this.m);
        }
        this.g.setEnabled(this.isZoomable() && this.isPannable());
    }

    public NavigationDirection getNavigateDirection() {
        if (this.m != null) {
            boolean bl = this.k.getAxes().contains(XYPlot.AXIS_X);
            boolean bl2 = this.k.getAxes().contains(XYPlot.AXIS_Y);
            if (bl && bl2) {
                return NavigationDirection.ARBITRARY;
            }
            if (bl) {
                return NavigationDirection.HORIZONTAL;
            }
            return NavigationDirection.VERTICAL;
        }
        return null;
    }

    public void setNavigateDirection(NavigationDirection object) {
        if (this.m != null) {
            if (NavigationDirection.HORIZONTAL.equals(object)) {
                this.k.setAxes(XYPlot.AXIS_X);
                return;
            }
            if (NavigationDirection.VERTICAL.equals(object)) {
                this.k.setAxes(XYPlot.AXIS_Y);
                return;
            }
            object = this.k.getPlot().getAxesNames();
            this.k.setAxes((Collection<String>)object);
        }
    }

    public void setDefaultState() {
        if (this.k != null) {
            this.k.setDefaultState();
        }
    }

    static /* synthetic */ void a(InteractivePanel interactivePanel, double d) {
        if (interactivePanel.isZoomable()) {
            double d2 = interactivePanel.k.getZoom() * Math.pow(0.8, d);
            interactivePanel.k.setZoom(d2);
            interactivePanel.repaint();
        }
    }

    private static final class b
    extends MouseAdapter {
        private final PlotNavigator a;
        private final Plot b;
        private Point c;

        public b(PlotNavigator plotNavigator) {
            this.a = plotNavigator;
            this.b = plotNavigator.getPlot();
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.c = mouseEvent.getPoint();
        }

        public final void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getPoint();
            int n = -((Point)object).x + this.c.x;
            int n2 = ((Point)object).y - this.c.y;
            this.c = object;
            if (Math.abs(n) > 0 || Math.abs(n2) > 0) {
                AxisRenderer axisRenderer;
                Object object2;
                Object object3;
                object = this.b.getAxisRenderer(XYPlot.AXIS_X);
                if (object != null) {
                    if (((Boolean)object.getSetting(AxisRenderer.SHAPE_DIRECTION_SWAPPED)).booleanValue()) {
                        n = -n;
                    }
                    object3 = this.b.getAxis(XYPlot.AXIS_X);
                    double d = object.worldToView((Axis)object3, this.a.getCenter(XYPlot.AXIS_X), true);
                    object2 = object.viewToWorld((Axis)object3, d + (double)n, true);
                    this.a.setCenter(XYPlot.AXIS_X, (Number)object2);
                }
                if ((object = this.b.getAxisRenderer(XYPlot.AXIS_X2)) != null) {
                    if (((Boolean)object.getSetting(AxisRenderer.SHAPE_DIRECTION_SWAPPED)).booleanValue()) {
                        n = -n;
                    }
                    Axis axis = this.b.getAxis(XYPlot.AXIS_X2);
                    double d = object.worldToView(axis, this.a.getCenter(XYPlot.AXIS_X2), true);
                    Number number = object.viewToWorld(axis, d + (double)n, true);
                    this.a.setCenter(XYPlot.AXIS_X2, number);
                }
                if ((object3 = this.b.getAxisRenderer(XYPlot.AXIS_Y)) != null) {
                    if (((Boolean)object3.getSetting(AxisRenderer.SHAPE_DIRECTION_SWAPPED)).booleanValue()) {
                        n2 = -n2;
                    }
                    Axis axis = this.b.getAxis(XYPlot.AXIS_Y);
                    double d = object3.worldToView(axis, this.a.getCenter(XYPlot.AXIS_Y), true);
                    Number number = object3.viewToWorld(axis, d + (double)n2, true);
                    this.a.setCenter(XYPlot.AXIS_Y, number);
                }
                if ((axisRenderer = this.b.getAxisRenderer(XYPlot.AXIS_Y2)) != null) {
                    if (((Boolean)axisRenderer.getSetting(AxisRenderer.SHAPE_DIRECTION_SWAPPED)).booleanValue()) {
                        n2 = -n2;
                    }
                    object2 = this.b.getAxis(XYPlot.AXIS_Y2);
                    double d = axisRenderer.worldToView((Axis)object2, this.a.getCenter(XYPlot.AXIS_Y2), true);
                    object = axisRenderer.viewToWorld((Axis)object2, d + (double)n2, true);
                    this.a.setCenter(XYPlot.AXIS_Y2, (Number)object);
                }
                if (mouseEvent.getSource() instanceof Component) {
                    ((Component)mouseEvent.getSource()).repaint();
                }
            }
        }
    }

    private static final class a
    extends MouseAdapter {
        private final JPopupMenu a;

        public a(JPopupMenu jPopupMenu) {
            this.a = jPopupMenu;
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.a(mouseEvent);
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.a(mouseEvent);
        }

        private void a(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.a.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private final class c
    extends MouseAdapter
    implements MouseWheelListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private /* synthetic */ InteractivePanel a;

        private c(InteractivePanel interactivePanel, byte by) {
            this.a = interactivePanel;
        }

        public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            InteractivePanel.a(this.a, -mouseWheelEvent.getWheelRotation());
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                InteractivePanel.a(this.a, 1.0);
            }
        }

        /* synthetic */ c(InteractivePanel interactivePanel) {
            this(interactivePanel, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NavigationDirection {
        HORIZONTAL,
        VERTICAL,
        ARBITRARY;

    }
}

