/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.points.DefaultPointRenderer;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class SizeablePointRenderer
extends DefaultPointRenderer {
    public static final SettingsStorage.Key COLUMN = new SettingsStorage.Key("sizeablePoint.column");

    public SizeablePointRenderer() {
        this.setSettingDefault(COLUMN, 2);
    }

    public Shape getPointPath(Row row) {
        Shape shape = (Shape)this.getSetting(SHAPE);
        int n = ((Number)this.getSetting(COLUMN)).intValue();
        if (n >= row.size()) {
            return shape;
        }
        double d = row.get(n).doubleValue();
        if (d < 0.0 || Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        if (d != 1.0) {
            shape = AffineTransform.getScaleInstance(d, d).createTransformedShape(shape);
        }
        return shape;
    }
}

