/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.points.DefaultPointRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.text.NumberFormat;

public class LabelPointRenderer
extends DefaultPointRenderer {
    public static final SettingsStorage.Key COLUMN = new SettingsStorage.Key("labelPoint.column");
    public static final SettingsStorage.Key FORMAT = new SettingsStorage.Key("labelPoint.format");
    public static final SettingsStorage.Key FONT = new SettingsStorage.Key("labelPoint.font");
    public static final SettingsStorage.Key ALIGNMENT_X = new SettingsStorage.Key("label.alignment.x");
    public static final SettingsStorage.Key ALIGNMENT_Y = new SettingsStorage.Key("label.alignment.y");

    public LabelPointRenderer() {
        this.setSettingDefault(COLUMN, 1);
        this.setSettingDefault(FORMAT, NumberFormat.getInstance());
        this.setSettingDefault(FONT, Font.decode(null));
        this.setSettingDefault(ALIGNMENT_X, 0.5);
        this.setSettingDefault(ALIGNMENT_Y, 0.5);
    }

    public Shape getPointPath(Row object) {
        int n = ((Number)this.getSetting(COLUMN)).intValue();
        if (n >= ((Row)object).size()) {
            return null;
        }
        if ((object = ((Row)object).get(n)) == null) {
            return null;
        }
        object = GraphicsUtils.getLayout(((Format)this.getSetting(FORMAT)).format(object), (Font)this.getSetting(FONT)).getOutline(null);
        double d = ((Number)this.getSetting(ALIGNMENT_X)).doubleValue();
        double d2 = ((Number)this.getSetting(ALIGNMENT_Y)).doubleValue();
        Rectangle2D rectangle2D = object.getBounds2D();
        return AffineTransform.getTranslateInstance(-d * rectangle2D.getWidth(), d2 * rectangle2D.getHeight()).createTransformedShape((Shape)object);
    }
}

