/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.AbstractDrawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.plots.Label;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.BasicSettingsStorage;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SettingChangeEvent;
import de.erichseifert.gral.util.SettingsListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.text.NumberFormat;

public abstract class AbstractPointRenderer
extends BasicSettingsStorage
implements PointRenderer,
SettingsListener {
    public AbstractPointRenderer() {
        this.addSettingsListener(this);
        this.setSettingDefault(SHAPE, new Rectangle2D.Double(-2.5, -2.5, 5.0, 5.0));
        this.setSettingDefault(COLOR, Color.BLACK);
        this.setSettingDefault(VALUE_DISPLAYED, false);
        this.setSettingDefault(VALUE_FORMAT, NumberFormat.getInstance());
        this.setSettingDefault(VALUE_ALIGNMENT_X, 0.5);
        this.setSettingDefault(VALUE_ALIGNMENT_Y, 0.5);
        this.setSettingDefault(VALUE_COLOR, Color.BLACK);
        this.setSettingDefault(ERROR_DISPLAYED, false);
        this.setSettingDefault(ERROR_COLOR, Color.BLACK);
        this.setSettingDefault(ERROR_SHAPE, new Line2D.Double(-2.0, 0.0, 2.0, 0.0));
        this.setSettingDefault(ERROR_STROKE, new BasicStroke(1.0f));
    }

    protected void drawValue(DrawingContext drawingContext, Shape shape, Object object) {
        object = ((Format)this.getSetting(VALUE_FORMAT)).format(object);
        object = new Label((String)object);
        ((BasicSettingsStorage)object).setSetting(Label.ALIGNMENT_X, this.getSetting(VALUE_ALIGNMENT_X));
        ((BasicSettingsStorage)object).setSetting(Label.ALIGNMENT_Y, this.getSetting(VALUE_ALIGNMENT_Y));
        ((BasicSettingsStorage)object).setSetting(Label.COLOR, this.getSetting(VALUE_COLOR));
        ((AbstractDrawable)object).setBounds(shape.getBounds2D());
        ((Label)object).draw(drawingContext);
    }

    protected void drawError(DrawingContext object, Shape object2, double d, double d2, double d3, Axis axis, AxisRenderer axisRenderer) {
        if (axisRenderer == null) {
            return;
        }
        double d4 = object2.getBounds2D().getCenterX();
        double d5 = d + d2;
        double d6 = d - d3;
        double d7 = axisRenderer.getPosition(axis, d, true, false).get(1);
        double d8 = axisRenderer.getPosition(axis, d5, true, false).get(1) - d7;
        double d9 = axisRenderer.getPosition(axis, d6, true, false).get(1) - d7;
        object2 = new Point2D.Double(d4, d8);
        Object object3 = new Point2D.Double(d4, d9);
        object2 = new Line2D.Double((Point2D)object2, (Point2D)object3);
        object3 = (Paint)this.getSetting(ERROR_COLOR);
        Object object4 = (Stroke)this.getSetting(ERROR_STROKE);
        object = ((DrawingContext)object).getGraphics();
        GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object2, (Paint)object3, null, (Stroke)object4);
        object2 = (Shape)this.getSetting(ERROR_SHAPE);
        object4 = ((Graphics2D)object).getTransform();
        ((Graphics2D)object).translate(d4, d8);
        BasicStroke basicStroke = new BasicStroke(1.0f);
        GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object2, (Paint)object3, null, basicStroke);
        ((Graphics2D)object).setTransform((AffineTransform)object4);
        ((Graphics2D)object).translate(d4, d9);
        GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object2, (Paint)object3, null, basicStroke);
        ((Graphics2D)object).setTransform((AffineTransform)object4);
    }

    public void settingChanged(SettingChangeEvent settingChangeEvent) {
    }
}

